/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.KeRun;
import io.vertx.tp.optic.environment.Indent;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

class KeData {
    KeData() {
    }

    static <T> Future<List<T>> indent(List<T> input, String sigma, String code, BiConsumer<T, String> fnConsumer) {
        if (Objects.isNull(input) || input.isEmpty()) {
            return Ux.future(new ArrayList());
        }
        return KeRun.channel(Indent.class, () -> input, stub -> stub.indent(code, sigma, input.size()).compose(queue -> {
            input.forEach(entity -> fnConsumer.accept(entity, (String)queue.poll()));
            return Ux.future((Object)input);
        }));
    }

    static <T> Future<T> indent(T input, String sigma, String code, BiConsumer<T, String> fnConsumer) {
        return KeRun.channel(Indent.class, () -> input, stub -> {
            if (Ut.isNil((String)sigma)) {
                return Ux.future((Object)input);
            }
            return stub.indent(code, sigma).compose(indent -> {
                fnConsumer.accept(input, (String)indent);
                return Ux.future((Object)input);
            });
        });
    }

    static Future<JsonObject> indent(JsonObject data, String code) {
        return KeRun.channel(Indent.class, () -> data, stub -> {
            String sigma = data.getString("sigma");
            if (Ut.isNil((String)sigma) || Ut.isNil((String)code)) {
                return Ux.future((Object)data);
            }
            return stub.indent(code, sigma).compose(indent -> Ux.future((Object)data.put("indent", indent)));
        });
    }

    static Future<JsonArray> indent(JsonArray data, String code) {
        return KeRun.channel(Indent.class, () -> data, stub -> {
            String sigma = Ut.valueString((JsonArray)data, (String)"sigma");
            if (Ut.isNil((String)sigma)) {
                return Ux.future((Object)data);
            }
            return stub.indent(code, sigma, data.size()).compose(indentQ -> {
                Ut.itJArray((JsonArray)data).forEach(json -> json.put("indent", indentQ.poll()));
                return Ux.future((Object)data);
            });
        });
    }
}

