/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.atom;

import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.config.Database;
import io.vertx.up.util.Ut;
import java.io.Serializable;

public class KEnv
implements Serializable {
    private final transient String sigma;
    private final transient String appId;
    private final transient String appKey;
    private final transient String language;
    private final transient String name;
    private final transient String code;
    private final transient Database database;

    private KEnv(JsonObject data) {
        JsonObject dataJ = Ut.valueJObject((JsonObject)data);
        this.appId = dataJ.getString("appId");
        this.appKey = dataJ.getString("appKey");
        this.sigma = dataJ.getString("sigma");
        this.code = dataJ.getString("code");
        this.name = dataJ.getString("name");
        this.language = dataJ.getString("language");
        this.database = new Database();
        this.database.fromJson(dataJ.getJsonObject("source", new JsonObject()));
    }

    public static KEnv instance(JsonObject unityApp) {
        return new KEnv(unityApp);
    }

    public String sigma() {
        return this.sigma;
    }

    public String appId() {
        return this.appId;
    }

    public String appKey() {
        return this.appKey;
    }

    public String language() {
        return this.language;
    }

    public String name() {
        return this.name;
    }

    public String code() {
        return this.code;
    }

    public Database database() {
        return this.database;
    }

    public String toString() {
        return "KEnv{sigma='" + this.sigma + "', appId='" + this.appId + "', appKey='" + this.appKey + "', language='" + this.language + "', name='" + this.name + "', code='" + this.code + "'}";
    }
}

