/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.atom;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.Pocket;
import io.vertx.tp.optic.atom.Lexeme;
import io.vertx.up.log.Annal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;

public class Income
implements Serializable {
    private static final Annal LOGGER = Annal.get(Income.class);
    private final transient Vector<Object> queue = new Vector();
    private final transient List<String> names = new ArrayList<String>();

    private <T> Income(Class<T> key) {
        Lexeme<T> lexeme = Pocket.get(key);
        if (Objects.nonNull(lexeme)) {
            this.names.addAll(lexeme.params());
        }
    }

    public static <T> Income in(Class<T> key) {
        return new Income(key);
    }

    public <T> Income in(T value) {
        this.queue.add(value);
        return this;
    }

    public JsonObject arguments() {
        JsonObject arguments = new JsonObject();
        int size = this.names.size();
        for (int idx = 0; idx < size; ++idx) {
            String field = this.names.get(idx);
            if (this.queue.isEmpty()) continue;
            Object value = this.queue.get(idx);
            Ke.debugKe(LOGGER, "[ Income ] field = {0}, value = {1}", field, value);
            arguments.put(field, value);
        }
        return arguments;
    }
}

