/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.tunnel;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._501JooqReferenceException;
import io.vertx.tp.ke.tunnel.Nexus;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

class NexusLinker
implements Nexus {
    private final transient Class<?> entityT;
    private transient UxJooq jooq;

    public NexusLinker(Class<?> entityT) {
        this.entityT = entityT;
    }

    @Override
    public Nexus on(UxJooq jooq) {
        this.jooq = jooq;
        return this;
    }

    @Override
    public Future<JsonObject> fetchNexus(JsonObject filters) {
        return this.execute(filters, condition -> {
            condition.put("", (Object)Boolean.TRUE);
            condition.put("sigma", (Object)filters.getString("sigma"));
            return this.jooq.fetchOneAsync(condition).compose(Ux::futureJ);
        });
    }

    @Override
    public Future<JsonArray> fetchNexus(Set<String> keys) {
        return this.execute(() -> {
            JsonObject condition = new JsonObject();
            condition.put("modelKey,i", (Object)Ut.toJArray((Set)keys));
            return this.jooq.fetchInAsync("modelKey", Ut.toJArray((Set)keys)).compose(Ux::futureA);
        });
    }

    @Override
    public Future<JsonObject> updateNexus(String key, JsonObject params) {
        return this.execute(params, updatedData -> this.jooq.fetchByIdAsync((Object)key).compose(Ux::futureJ).compose(original -> {
            original.mergeIn(updatedData);
            Object entity = Ut.deserialize((JsonObject)original, this.entityT);
            return this.jooq.updateAsync(entity).compose(Ux::futureJ);
        }));
    }

    private <T> Future<T> execute(JsonObject params, Function<JsonObject, Future<T>> future) {
        if (Objects.isNull(this.jooq)) {
            return Future.failedFuture((Throwable)((Object)new _501JooqReferenceException(this.getClass())));
        }
        JsonObject data = this.getData(params);
        if (Objects.isNull(data)) {
            return Future.failedFuture((Throwable)((Object)new _501JooqReferenceException(this.getClass())));
        }
        return future.apply(data);
    }

    private <T> Future<T> execute(Supplier<Future<T>> future) {
        if (Objects.isNull(this.jooq)) {
            return Future.failedFuture((Throwable)((Object)new _501JooqReferenceException(this.getClass())));
        }
        return future.get();
    }

    private JsonObject getData(JsonObject json) {
        if (Ut.isNil((JsonObject)json)) {
            return null;
        }
        JsonObject nexusData = new JsonObject();
        nexusData.put("modelId", (Object)json.getString("identifier"));
        nexusData.put("modelKey", (Object)json.getString("key"));
        return nexusData;
    }
}

