/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.Orbit;
import io.vertx.tp.optic.Pocket;
import io.vertx.tp.optic.atom.Income;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroAnno;

class KeCache {
    private static final Annal LOGGER = Annal.get(KeCache.class);
    private static final String LOGGER_VIEW = "Input view = {1}, Try cacheKey: \u001b[0;34m{0}\u001b[m, uri = {2}, method = {3}";

    KeCache() {
    }

    static String keyView(String method, String uri, Vis view) {
        return "session-" + method + ":" + uri + ":" + view.position() + "/" + view.view();
    }

    static String keyAuthorized(String method, String uri) {
        return "authorized-" + method + ":" + uri;
    }

    static String keyResource(String method, String uri) {
        return "resource-" + method + ":" + uri;
    }

    static String uri(String uri, String requestUri) {
        return Ke.channelSync(Orbit.class, () -> uri, orbit -> {
            Income income = Pocket.income(Orbit.class, uri, requestUri);
            return orbit.analyze(income.arguments());
        });
    }

    static String uri(RoutingContext context) {
        HttpServerRequest request = context.request();
        HttpMethod method = request.method();
        String requestUri = ZeroAnno.recoveryUri((String)request.path(), (HttpMethod)method);
        return KeCache.uri(requestUri, request.path());
    }

    static String keyView(RoutingContext context) {
        HttpServerRequest request = context.request();
        String uri = KeCache.uri(context);
        String literal = request.getParam("view");
        String cacheKey = KeCache.keyView(request.method().name(), uri, Vis.create((String)literal));
        Ke.infoKe(LOGGER, LOGGER_VIEW, cacheKey, literal, uri, request.method().name());
        return cacheKey;
    }
}

