/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.tp.ke.refine.KeCache;
import io.vertx.tp.ke.refine.KeCompare;
import io.vertx.tp.ke.refine.KeExcel;
import io.vertx.tp.ke.refine.KeLog;
import io.vertx.tp.ke.refine.KeRun;
import io.vertx.tp.ke.refine.KeTool;
import io.vertx.up.atom.record.Apt;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.commune.element.TypeAtom;
import io.vertx.up.log.Annal;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Ke {
    public static String getDatabase() {
        return KeTool.getCatalog();
    }

    public static <T> Future<T> poolAsync(String name, String key, Supplier<Future<T>> supplier) {
        return KeTool.poolAsync(name, key, supplier);
    }

    public static Future<JsonArray> combineAsync(JsonArray data, ConcurrentMap<String, String> headers) {
        return KeExcel.combineAsync(data, headers);
    }

    public static Future<JsonArray> combineAsync(JsonArray data, ConcurrentMap<String, String> headers, List<String> columns) {
        return KeExcel.combineAsync(data, headers, columns, null);
    }

    public static Future<JsonArray> combineAsync(JsonArray data, ConcurrentMap<String, String> headers, List<String> columns, TypeAtom TypeAtom2) {
        return KeExcel.combineAsync(data, headers, columns, TypeAtom2);
    }

    public static Function<JsonObject, Future<JsonObject>> fabricAsync(String field) {
        return KeCompare.combineAsync(field);
    }

    public static void banner(String module) {
        KeTool.banner(module);
    }

    public static void infoKe(Annal logger, String pattern, Object ... args) {
        KeLog.infoKe(logger, pattern, args);
    }

    public static void debugKe(Annal logger, String pattern, Object ... args) {
        KeLog.debugKe(logger, pattern, args);
    }

    public static void runString(Supplier<String> supplier, Consumer<String> consumer) {
        KeTool.consume(supplier, consumer);
    }

    public static void runBoolean(Supplier<Boolean> supplier, Consumer<Boolean> consumer) {
        KeTool.consume(supplier, consumer);
    }

    public static void runInteger(Supplier<Integer> supplier, Consumer<Integer> consumer) {
        KeTool.consume(supplier, consumer);
    }

    public static <T, O> Future<O> channel(Class<T> clazz, Supplier<O> supplier, Function<T, Future<O>> executor) {
        return KeRun.channel(clazz, supplier, executor);
    }

    public static <T, O> O channelSync(Class<T> clazz, Supplier<O> supplier, Function<T, O> executor) {
        return KeRun.channelSync(clazz, supplier, executor);
    }

    public static <T, O> Future<O> channelAsync(Class<T> clazz, Supplier<Future<O>> supplier, Function<T, Future<O>> executor) {
        return KeRun.channelAsync(clazz, supplier, executor);
    }

    public static String uri(String uri, String requestUri) {
        return KeCache.uri(uri, requestUri);
    }

    public static String uri(RoutingContext context) {
        return KeCache.uri(context);
    }

    public static String keyView(String method, String uri, Vis view) {
        return KeCache.keyView(method, uri, view);
    }

    public static String keyView(RoutingContext context) {
        return KeCache.keyView(context);
    }

    public static String keyAuthorized(String method, String uri) {
        return KeCache.keyAuthorized(method, uri);
    }

    public static String keyResource(String method, String uri) {
        return KeCache.keyResource(method, uri);
    }

    public static Apt compmared(Apt apt, String user) {
        return KeCompare.compared(apt, "code", user);
    }

    public static Apt compmared(Apt apt, String field, String user) {
        return KeCompare.compared(apt, field, user);
    }

    public static BiFunction<Function<JsonArray, Future<JsonArray>>, Function<JsonArray, Future<JsonArray>>, Future<JsonArray>> atomyFn(Class<?> clazz, Apt compared) {
        return KeCompare.atomyFn(clazz, compared);
    }
}

