/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.booter;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.ExcelInfix;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.tp.plugin.redis.RedisInfix;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxTimer;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class BtLoader {
    private static final Annal LOGGER = Annal.get(BtLoader.class);

    BtLoader() {
    }

    static Handler<AsyncResult<Boolean>> handlerComplete(String folder, String prefix, UxTimer timer) {
        return handler -> {
            if (handler.succeeded()) {
                if (Objects.isNull(prefix)) {
                    Ke.infoKe(LOGGER, "The data folder `{0}` has been imported successfully!", folder);
                } else {
                    Ke.infoKe(LOGGER, "The data folder `{0}` with `{1}` has been imported successfully!", folder, prefix);
                }
                timer.end(System.currentTimeMillis());
                Ke.infoKe(LOGGER, "TOTAL EXECUTION TIME = The total execution time = {0}!", timer.value());
                System.exit(0);
            } else {
                handler.cause().printStackTrace();
            }
        };
    }

    static Future<Boolean> impAsync(String folder) {
        ArrayList futures = new ArrayList();
        BtLoader.stream(folder, null).map(BtLoader::importFuture).forEach(futures::add);
        return Ux.thenCombineT(futures).compose(nil -> Future.succeededFuture((Object)Boolean.TRUE));
    }

    static Future<Boolean> impAsync(String folder, String prefix) {
        ArrayList futures = new ArrayList();
        BtLoader.stream(folder, prefix).map(BtLoader::importFuture).forEach(futures::add);
        return Ux.thenCombineT(futures).compose(nil -> Future.succeededFuture((Object)Boolean.TRUE));
    }

    static void doImport(String filename, Handler<AsyncResult<String>> callback) {
        WorkerExecutor executor = Ux.nativeWorker((String)filename);
        executor.executeBlocking(pre -> {
            ExcelClient client = ExcelInfix.createClient();
            Ke.infoKe(LOGGER, "Excel importing file = {0}", filename);
            client.importAsync(filename, handler -> {
                if (handler.succeeded()) {
                    pre.complete((Object)filename);
                } else {
                    pre.fail(handler.cause());
                }
            });
        }, post -> callback.handle((Object)Future.succeededFuture((Object)((String)post.result()))));
    }

    static void doIngests(String folder, Handler<AsyncResult<Set<ExTable>>> callback) {
        List futures = BtLoader.stream(folder, null).map(BtLoader::ingestFuture).collect(Collectors.toList());
        CompositeFuture.join(futures).compose(result -> {
            List async = result.list();
            HashSet tables = new HashSet();
            async.forEach(tables::addAll);
            callback.handle((Object)Future.succeededFuture(tables));
            return Future.succeededFuture((Object)Boolean.TRUE);
        });
    }

    static void doIngest(String filename, Handler<AsyncResult<Set<ExTable>>> callback) {
        ExcelClient client = ExcelInfix.getClient();
        client.ingest(filename, handler -> callback.handle((Object)Future.succeededFuture((Object)((Set)handler.result()))));
    }

    private static Stream<String> stream(String folder, String prefix) {
        return Ut.ioFilesN((String)folder, null, (String)prefix).stream().filter(BtLoader::ensureFile);
    }

    private static boolean ensureFile(String filename) {
        if (Ut.isNil((String)filename)) {
            return false;
        }
        if (filename.contains("~")) {
            return false;
        }
        return filename.endsWith("xlsx") || filename.endsWith("xls");
    }

    private static void out(String filename) {
        Ke.infoKe(LOGGER, "Successfully to finish loading ! data file = {0}", filename);
    }

    private static Future<Set<ExTable>> ingestFuture(String filename) {
        Promise promise = Promise.promise();
        BtLoader.doIngest(filename, (Handler<AsyncResult<Set<ExTable>>>)((Handler)handler -> promise.complete((Object)((Set)handler.result()))));
        return promise.future();
    }

    private static Future<String> importFuture(String filename) {
        Promise promise = Promise.promise();
        BtLoader.doImport(filename, (Handler<AsyncResult<String>>)((Handler)handler -> {
            promise.complete((Object)((String)handler.result()));
            BtLoader.out(filename);
        }));
        return promise.future();
    }

    static {
        ExcelInfix.init((Vertx)Ux.nativeVertx());
        JooqInfix.init((Vertx)Ux.nativeVertx());
        RedisInfix.disabled();
    }
}

