/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.atom.specification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ClassDeserializer;
import com.fasterxml.jackson.databind.ClassSerializer;
import com.fasterxml.jackson.databind.JsonObjectDeserializer;
import com.fasterxml.jackson.databind.JsonObjectSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._409JoinTargetException;
import io.vertx.tp.ke.cv.em.JoinMode;
import io.vertx.up.commune.exchange.BiMapping;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;

public class KPoint
implements Serializable {
    @JsonIgnore
    private transient String identifier;
    private transient String crud;
    @JsonSerialize(using=ClassSerializer.class)
    @JsonDeserialize(using=ClassDeserializer.class)
    private transient Class<?> classDao;
    @JsonSerialize(using=ClassSerializer.class)
    @JsonDeserialize(using=ClassDeserializer.class)
    private transient Class<?> classDefine;
    private transient String key;
    private transient String keyJoin;
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private transient JsonObject synonym;

    public String getCrud() {
        return this.crud;
    }

    public void setCrud(String crud) {
        this.crud = crud;
    }

    public String getKey() {
        return Ut.isNil((String)this.key) ? "key" : this.key;
    }

    public void setKey(String key) {
        if (Ut.notNil((String)key)) {
            this.key = key;
        }
    }

    public String getKeyJoin() {
        return this.keyJoin;
    }

    public void setKeyJoin(String keyJoin) {
        this.keyJoin = keyJoin;
    }

    public Class<?> getClassDao() {
        return this.classDao;
    }

    public void setClassDao(Class<?> classDao) {
        this.classDao = classDao;
    }

    public Class<?> getClassDefine() {
        return this.classDefine;
    }

    public void setClassDefine(Class<?> classDefine) {
        this.classDefine = classDefine;
    }

    public JsonObject getSynonym() {
        return this.synonym;
    }

    public void setSynonym(JsonObject synonym) {
        this.synonym = synonym;
    }

    public BiMapping synonym() {
        return new BiMapping(this.synonym);
    }

    public JoinMode modeTarget() {
        if (Ut.notNil((String)this.crud)) {
            return JoinMode.CRUD;
        }
        if (Objects.nonNull(this.classDao)) {
            return JoinMode.DAO;
        }
        Fn.out((boolean)Objects.isNull(this.classDefine), _409JoinTargetException.class, (Object[])new Object[]{this.getClass()});
        return JoinMode.DEFINE;
    }

    public JoinMode modeSource() {
        if (Objects.nonNull(this.classDao)) {
            return JoinMode.DAO;
        }
        if (Objects.nonNull(this.classDefine)) {
            return JoinMode.DEFINE;
        }
        Fn.out((boolean)Ut.isNil((String)this.keyJoin), _409JoinTargetException.class, (Object[])new Object[]{this.getClass()});
        return JoinMode.CRUD;
    }

    public KPoint indent(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String indent() {
        return this.identifier;
    }

    public String toString() {
        return "KPoint{identifier='" + this.identifier + "', crud='" + this.crud + "', classDao=" + this.classDao + ", classDefine=" + this.classDefine + ", key='" + this.key + "', keyJoin='" + this.keyJoin + "', synonym=" + this.synonym + "}";
    }
}

