/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.atom.metadata;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._404IndentParsingException;
import io.vertx.tp.ke.atom.metadata.KPoint;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class KJoin
implements Serializable {
    private static final Annal LOGGER = Annal.get(KJoin.class);
    private volatile String targetIndent;
    private KPoint source;
    private ConcurrentMap<String, KPoint> target = new ConcurrentHashMap<String, KPoint>();

    public String getTargetIndent() {
        return this.targetIndent;
    }

    public void setTargetIndent(String targetIndent) {
        this.targetIndent = targetIndent;
    }

    public KPoint getSource() {
        return this.source;
    }

    public void setSource(KPoint source) {
        this.source = source;
    }

    public ConcurrentMap<String, KPoint> getTarget() {
        return this.target;
    }

    public void setTarget(ConcurrentMap<String, KPoint> target) {
        this.target = target;
    }

    public KPoint procTarget(JsonObject data) {
        String identifier = this.procIdentifier(data);
        if (Ut.isNil((String)identifier)) {
            return null;
        }
        KPoint target = this.target.getOrDefault(identifier, null);
        if (Objects.isNull(target)) {
            LOGGER.warn("System could not find configuration for `{0}`, data = {1}", new Object[]{identifier, data.encode()});
            return null;
        }
        return target.indent(identifier);
    }

    private String procIdentifier(JsonObject data) {
        if (Ut.isNil((String)this.targetIndent)) {
            LOGGER.warn("The `targetIndent` field is null", new Object[0]);
            return null;
        }
        String identifier = data.containsKey(this.targetIndent) ? data.getString(this.targetIndent) : this.targetIndent;
        Fn.out((boolean)Ut.isNil((String)identifier), _404IndentParsingException.class, (Object[])new Object[]{this.getClass(), this.targetIndent, data});
        return identifier;
    }

    public <T> T procTarget(JsonObject data, Function<KPoint, T> fnProcess) {
        KPoint point = this.procTarget(data);
        return fnProcess.apply(point);
    }

    public void procFilters(JsonObject data, KPoint target, JsonObject filterRef) {
        String joinedValue;
        KPoint source = this.source;
        if (Objects.nonNull(target) && Objects.nonNull(source) && Ut.notNil((String)(joinedValue = data.getString(source.getKey())))) {
            filterRef.put(target.getKeyJoin(), joinedValue);
        }
    }
}

