/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.atom;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.cv.em.JSource;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

public class KMetadata
implements Serializable {
    private static final Annal LOGGER = Annal.get(KMetadata.class);
    private static final String KEY_TYPE = "__type__";
    private static final String KEY_CONTENT = "__content__";
    private final transient JsonObject content = new JsonObject();

    public KMetadata(JsonObject input) {
        if (input.containsKey(KEY_TYPE)) {
            JsonObject normalized;
            JSource source = (JSource)Ut.toEnum(JSource.class, (String)input.getString(KEY_TYPE));
            JsonObject content = input.getJsonObject(KEY_CONTENT);
            Function<JsonObject, JsonObject> parser = this.getParser(source);
            if (Objects.nonNull(parser) && Objects.nonNull(normalized = parser.apply(content))) {
                this.content.mergeIn(normalized.copy(), true);
            }
        } else {
            this.content.mergeIn(input.copy(), true);
        }
    }

    private Function<JsonObject, JsonObject> getParser(JSource source) {
        if (JSource.FILE == source) {
            return this::fromFile;
        }
        return null;
    }

    private JsonObject fromFile(JsonObject content) {
        String path = content.getString("path");
        if (Ut.isNil((String)path)) {
            return new JsonObject();
        }
        try {
            return Ut.ioJObject((String)path);
        }
        catch (Throwable ex) {
            LOGGER.jvm(ex);
            return new JsonObject();
        }
    }

    public JsonObject toJson() {
        return this.content;
    }
}

