/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.element.Shape;
import io.vertx.up.commune.element.ShapeItem;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

class KeExcel {
    KeExcel() {
    }

    static Future<JsonArray> combineAsync(JsonArray data, ConcurrentMap<String, String> headers, List<String> columns, Shape shape) {
        JsonArray combined = new JsonArray();
        boolean complex = shape.isComplex();
        if (complex) {
            JsonArray firstCnHeader = new JsonArray();
            JsonArray firstEnHeader = new JsonArray();
            JsonArray secondCnHeader = new JsonArray();
            JsonArray secondEnHeader = new JsonArray();
            HashSet complexField = new HashSet();
            Ut.itList(columns, (column, index) -> {
                if (shape.isComplex(column)) {
                    complexField.add(column);
                    int columnSize = shape.size(column);
                    firstCnHeader.add(KeExcel.itemColumn(headers.get(column), columnSize));
                    firstEnHeader.add(KeExcel.itemColumn(column, columnSize));
                    ShapeItem item = shape.item(column);
                    if (Objects.nonNull(item)) {
                        int childCount = item.children().size() - 1;
                        Ut.itRepeat((Integer)childCount, () -> {
                            firstCnHeader.addNull();
                            firstEnHeader.addNull();
                        });
                        item.children().forEach(child -> {
                            secondCnHeader.add(child.getAlias());
                            secondEnHeader.add(child.getName());
                        });
                    }
                } else {
                    firstCnHeader.add(KeExcel.itemRow(headers.get(column), 2));
                    firstEnHeader.add(KeExcel.itemRow(column, 2));
                    secondCnHeader.addNull();
                    secondEnHeader.addNull();
                }
            });
            combined.add(firstCnHeader);
            combined.add(secondCnHeader);
            combined.add(firstEnHeader);
            combined.add(secondEnHeader);
            Ut.itJArray((JsonArray)data, (each, index) -> {
                int max = KeExcel.rowCalculate(each, complexField);
                JsonArray row = new JsonArray();
                columns.forEach(column -> {
                    if (shape.isComplex(column)) {
                        JsonArray columnValue = each.getJsonArray(column);
                        ShapeItem item = shape.item(column);
                        if (Ut.notNil((JsonArray)columnValue)) {
                            JsonObject value = columnValue.getJsonObject(0);
                            KeExcel.rowChild(item, value, row);
                        } else {
                            item.children().forEach(shapeItem -> row.addNull());
                        }
                    } else if (1 < max) {
                        row.add(KeExcel.itemRow(each.getValue(column), max));
                    } else {
                        row.add(each.getValue(column));
                    }
                });
                combined.add(row);
                int idx = 1;
                while (idx < max) {
                    JsonArray addOn = new JsonArray();
                    int maxIdx = idx++;
                    columns.forEach(column -> {
                        if (shape.isComplex(column)) {
                            ShapeItem item = shape.item(column);
                            JsonArray columnValue = each.getJsonArray(column);
                            int valueLength = columnValue.size();
                            if (Ut.notNil((JsonArray)columnValue) && 1 < columnValue.size()) {
                                if (maxIdx < valueLength) {
                                    JsonObject value = columnValue.getJsonObject(maxIdx);
                                    KeExcel.rowChild(item, value, addOn);
                                } else {
                                    item.children().forEach(shapeItem -> addOn.addNull());
                                }
                            } else {
                                item.children().forEach(shapeItem -> addOn.addNull());
                            }
                        } else {
                            addOn.addNull();
                        }
                    });
                    combined.add(addOn);
                }
            });
        } else {
            JsonArray labelHeader = new JsonArray();
            JsonArray fieldHeader = new JsonArray();
            columns.forEach(column -> {
                labelHeader.add((String)headers.get(column));
                fieldHeader.add(column);
            });
            combined.add(labelHeader);
            combined.add(fieldHeader);
            Ut.itJArray((JsonArray)data, (each, index) -> {
                JsonArray row = new JsonArray();
                columns.stream().map(arg_0 -> ((JsonObject)each).getValue(arg_0)).forEach(arg_0 -> ((JsonArray)row).add(arg_0));
                combined.add(row);
            });
        }
        return Ux.future((Object)combined);
    }

    static Future<JsonArray> combineAsync(JsonArray data, ConcurrentMap<String, String> headers) {
        ArrayList<String> columns = new ArrayList<String>(headers.keySet());
        return KeExcel.combineAsync(data, headers, columns, null);
    }

    private static JsonObject itemRow(Object item, int row) {
        JsonObject itemString = new JsonObject();
        itemString.put("rows", Integer.valueOf(row));
        itemString.put("cols", Integer.valueOf(0));
        itemString.put("value", item);
        return itemString;
    }

    private static JsonObject itemColumn(Object item, int column) {
        JsonObject itemString = new JsonObject();
        itemString.put("cols", Integer.valueOf(column));
        itemString.put("value", item);
        itemString.put("rows", Integer.valueOf(0));
        return itemString;
    }

    private static void rowChild(ShapeItem item, JsonObject value, JsonArray row) {
        item.children().forEach(shapeItem -> {
            if (Objects.isNull(value)) {
                row.addNull();
            } else {
                String childField = shapeItem.getName();
                Object childValue = value.getValue(childField);
                row.add(childValue);
            }
        });
    }

    private static int rowCalculate(JsonObject json, Set<String> fieldSet) {
        HashSet maxSet = new HashSet();
        fieldSet.forEach(field -> {
            Object value = json.getValue(field);
            if (Objects.nonNull(value)) {
                JsonArray ref;
                if (value instanceof JsonArray) {
                    ref = (JsonArray)value;
                    maxSet.add(ref.size());
                } else if (value instanceof String) {
                    ref = Ut.toJArray((String)value.toString());
                    maxSet.add(ref.size());
                } else {
                    ref = new JsonArray();
                    maxSet.add(0);
                }
                json.put(field, ref);
            }
        });
        return maxSet.stream().reduce(0, Math::max);
    }
}

