/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.atom.KeMetadata;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

class KeElement {
    KeElement() {
    }

    static Function<JsonObject, Future<JsonObject>> mountArray(String field) {
        return response -> Ux.future((Object)KeElement.mountArray(response, field));
    }

    static JsonObject mountArray(JsonObject response, String field) {
        return (JsonObject)Fn.getJvm((Object)new JsonObject(), () -> {
            String data = response.getString(field);
            if (Objects.nonNull(data) && Ut.isJArray((String)data)) {
                response.put(field, new JsonArray(data));
            }
            return response;
        }, (Object[])new Object[]{response});
    }

    static JsonObject mount(JsonObject response, String field) {
        return (JsonObject)Fn.getJvm((Object)new JsonObject(), () -> {
            String data = response.getString(field);
            if (Objects.nonNull(data) && Ut.isJObject((String)data)) {
                response.put(field, KeElement.parseMetadata(new JsonObject(data)));
            }
            return response;
        }, (Object[])new Object[]{response});
    }

    static JsonObject mountString(JsonObject response, String field) {
        return (JsonObject)Fn.getJvm((Object)new JsonObject(), () -> {
            Object value = response.getValue(field);
            if (Objects.nonNull(value)) {
                if (value instanceof JsonObject) {
                    response.put(field, ((JsonObject)value).encode());
                } else if (value instanceof JsonArray) {
                    response.put(field, ((JsonArray)value).encode());
                }
            }
            return response;
        }, (Object[])new Object[]{response});
    }

    static Function<JsonObject, Future<JsonObject>> mount(String field) {
        return response -> Ux.future((Object)KeElement.mount(response, field));
    }

    static Function<JsonArray, Future<JsonArray>> mounts(String field) {
        return response -> {
            Ut.itJArray((JsonArray)response).forEach(json -> KeElement.mount(json, field));
            return Ux.future((Object)response);
        };
    }

    static Function<JsonObject, Future<JsonObject>> mount(String ... field) {
        return response -> {
            Arrays.stream(field).forEach(each -> KeElement.mount(response, each));
            return Ux.future((Object)response);
        };
    }

    static Function<JsonArray, Future<JsonArray>> mounts(String ... field) {
        return response -> {
            Arrays.stream(field).forEach(each -> Ut.itJArray((JsonArray)response).forEach(json -> KeElement.mount(json, each)));
            return Ux.future((Object)response);
        };
    }

    private static JsonObject parseMetadata(JsonObject metadata) {
        assert (Objects.nonNull(metadata)) : "Here input metadata should not be null";
        return new KeMetadata(metadata).toJson();
    }
}

