/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Session;
import io.vertx.tp.error._409SessionConflictException;
import io.vertx.tp.plugin.session.SessionClient;
import io.vertx.tp.plugin.session.SessionInfix;
import io.vertx.up.commune.Envelop;
import io.vertx.up.unity.Ux;
import java.util.Objects;

class KeCache {
    private static final SessionClient CLIENT = SessionInfix.getClient();

    KeCache() {
    }

    static String keySession(String method, String uri) {
        return "session-" + method + ":" + uri;
    }

    static String keyAuthorized(String method, String uri) {
        return "authorized-" + method + ":" + uri;
    }

    static String keyHabitus(Envelop envelop) {
        String token = envelop.jwt();
        JsonObject tokenJson = Ux.Jwt.extract((String)token);
        return tokenJson.getString("habitus");
    }

    static String keyUser(Envelop envelop) {
        return KeCache.keyUser(envelop.user());
    }

    static String keyUser(User user) {
        JsonObject principle = user.principal();
        String token = principle.getString("jwt");
        JsonObject credential = Ux.Jwt.extract((String)token);
        return credential.getString("user");
    }

    static Future<Session> session(String id) {
        return CLIENT.get(id).compose(session -> {
            if (Objects.nonNull(session) && !session.isDestroyed()) {
                return Future.succeededFuture((Object)session);
            }
            _409SessionConflictException error = new _409SessionConflictException(KeCache.class, id);
            return Future.failedFuture((Throwable)((Object)error));
        });
    }

    static <T> Future<T> session(Session session, String sessionKey, String dataKey, T value) {
        Buffer storedBuffer = (Buffer)session.get(sessionKey);
        if (Objects.nonNull(storedBuffer)) {
            JsonObject storedData = storedBuffer.toJsonObject();
            storedData.put(dataKey, value);
            session.put(sessionKey, (Object)storedData.toBuffer());
        }
        return Ux.future(value);
    }
}

