/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.uca.business;

import cn.vertxup.jet.domain.tables.pojos.IService;
import io.aeon.experiment.rule.RuleUnique;
import io.horizon.specification.meta.action.Service;
import io.horizon.spi.environment.Ambient;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.atom.Refer;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.commune.exchange.BTree;
import io.vertx.up.commune.exchange.DFabric;
import io.vertx.up.commune.exchange.DSetting;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

public abstract class AbstractJob
implements Service {
    protected transient DFabric fabric;

    protected DSetting dict() {
        DSetting dict = Jt.toDict(this.service());
        if (Objects.isNull(this.fabric)) {
            this.fabric = DFabric.create().epsilon(dict.getEpsilon());
        }
        return dict;
    }

    public BTree mapping() {
        return Jt.toMapping(this.service());
    }

    public Identity identity() {
        return Jt.toIdentity(this.service());
    }

    public RuleUnique rule() {
        return Jt.toRule(this.service());
    }

    public JsonObject options() {
        IService service = this.service();
        JtApp app = Ambient.getApp(service.getSigma());
        return Jt.toOptions(app, service);
    }

    protected IService service() {
        JsonObject metadata = this.mission().getMetadata();
        return (IService)Ut.deserialize((JsonObject)metadata.getJsonObject("service"), IService.class);
    }

    protected abstract Mission mission();

    protected Database database() {
        return Jt.toDatabase(this.service());
    }

    protected Integration integration() {
        return Jt.toIntegration(this.service());
    }

    protected Future<Refer> underway(String identifier) {
        String key = this.service().getSigma();
        return Jt.toDictionary(key, "ZERO-CACHE-JOB_DIRECTORY", identifier, this.dict()).compose(dictionary -> {
            this.fabric.dictionary(dictionary);
            Refer refer = new Refer();
            refer.add(dictionary);
            return Ux.future((Object)refer);
        });
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }
}

