/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.uca.business;

import io.aeon.experiment.rule.RuleUnique;
import io.horizon.exception.web._501NotImplementException;
import io.horizon.specification.meta.action.Service;
import io.horizon.spi.jet.JtComponent;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Contract;
import io.vertx.up.commune.ActIn;
import io.vertx.up.commune.ActOut;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.commune.exchange.BTree;
import io.vertx.up.commune.exchange.DFabric;
import io.vertx.up.exception.web._400SigmaMissingException;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public abstract class AbstractComponent
implements JtComponent,
Service {
    @Contract
    protected transient XHeader header;
    @Contract
    protected transient DFabric fabric;
    @Contract
    private transient JsonObject options;
    @Contract
    private transient Identity identity;
    @Contract
    private transient BTree mapping;
    @Contract
    private transient RuleUnique rule;

    public JsonObject options() {
        return Objects.isNull(this.options) ? new JsonObject() : this.options.copy();
    }

    public Identity identity() {
        return this.identity;
    }

    public BTree mapping() {
        return this.mapping;
    }

    public RuleUnique rule() {
        return this.rule;
    }

    protected Future<ActOut> transferAsync(ActIn request, Function<String, Future<ActOut>> executor) {
        String sigma = request.sigma();
        if (Ut.isNil((String)sigma)) {
            _400SigmaMissingException error = new _400SigmaMissingException(this.getClass());
            return ActOut.future((Throwable)error);
        }
        return executor.apply(sigma);
    }

    @Override
    public Future<ActOut> transferAsync(ActIn actIn) {
        _501NotImplementException error = new _501NotImplementException(this.getClass());
        return Future.failedFuture((Throwable)error);
    }

    protected <T> void contract(T instance) {
        if (Objects.nonNull(instance)) {
            Ut.contract(instance, JsonObject.class, (Object)this.options());
            Ut.contract(instance, Identity.class, (Object)this.identity());
            Ut.contract(instance, BTree.class, (Object)this.mapping());
            Ut.contract(instance, DFabric.class, (Object)this.fabric);
            Ut.contract(instance, XHeader.class, (Object)this.header);
            Ut.contract(instance, RuleUnique.class, (Object)this.rule);
        }
    }

    protected DFabric fabric(JsonObject configured) {
        ConcurrentMap compiled = Ux.dictEpsilon((JsonObject)configured);
        return this.fabric.copy().epsilon(compiled);
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }
}

