/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtConfig;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;
import jakarta.ws.rs.core.MediaType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

class JtRoute {
    private static final Node<JsonObject> UNIFORM = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);

    JtRoute() {
    }

    static Set<String> toSet(Supplier<String> supplier) {
        String inputRequired = supplier.get();
        HashSet<String> result = new HashSet<String>();
        if (Ut.isNotNil((String)inputRequired) && Ut.isJArray((String)inputRequired)) {
            JsonArray mimeArr = new JsonArray(inputRequired);
            mimeArr.stream().map(item -> (String)item).forEach(result::add);
        }
        return result;
    }

    static String toPath(Supplier<String> routeSupplier, Supplier<String> uriSupplier, boolean secure) {
        JsonObject config = (JsonObject)UNIFORM.read();
        JsonObject configRouter = Ut.valueJObject((JsonObject)config, (String)"router");
        JtConfig configuration = (JtConfig)Ut.deserialize((JsonObject)configRouter, JtConfig.class);
        return JtRoute.toPath(routeSupplier, uriSupplier, secure, configuration);
    }

    static String toPath(Supplier<String> routeSupplier, Supplier<String> uriSupplier, boolean secure, JtConfig config) {
        String path;
        String root;
        StringBuilder uri = new StringBuilder();
        if (secure) {
            String wall = config.getWall();
            if (Ut.isNil((String)wall)) {
                wall = "";
            }
            if (wall.startsWith("/")) {
                uri.append(wall);
            } else {
                uri.append(wall);
            }
        }
        if (Ut.isNotNil((String)(root = routeSupplier.get()))) {
            uri.append(root).append(root.endsWith("/") ? "" : "/");
        }
        if (Ut.isNotNil((String)(path = uriSupplier.get()))) {
            uri.append(path);
        }
        return uri.toString().replace("//", "/");
    }

    static Set<MediaType> toMime(Supplier<String> supplier) {
        String mime = supplier.get();
        HashSet<MediaType> mimeSet = new HashSet<MediaType>();
        if (Ut.isNotNil((String)mime) && Ut.isJArray((String)mime)) {
            JsonArray mimeArr = new JsonArray(mime);
            mimeArr.stream().map(item -> (String)item).map(MediaType::valueOf).forEach(mimeSet::add);
        }
        if (mimeSet.isEmpty()) {
            mimeSet.add(MediaType.APPLICATION_JSON_TYPE);
        }
        return mimeSet;
    }
}

