/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.refine;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.atom.JtWorker;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class JtDelivery {
    JtDelivery() {
    }

    static ConcurrentMap<String, JtUri> answer(JsonObject config) {
        ConcurrentHashMap<String, JtUri> uriMap = new ConcurrentHashMap<String, JtUri>();
        for (String apiKey : config.fieldNames()) {
            JsonObject configData = config.getJsonObject(apiKey);
            JtUri uri = new JtUri();
            uri.fromJson(configData);
            uriMap.put(apiKey, uri);
        }
        return uriMap;
    }

    static ConcurrentMap<String, JsonObject> ask(Set<JtUri> uriSet) {
        ConcurrentHashMap<String, JsonObject> configMap = new ConcurrentHashMap<String, JsonObject>();
        uriSet.forEach(uri -> {
            JtWorker worker = uri.worker();
            String key = worker.getWorkerClass().getName();
            JsonObject config = configMap.getOrDefault(key, new JsonObject());
            config.put(uri.key(), (Object)uri.toJson());
            configMap.put(key, config);
        });
        return configMap;
    }
}

