/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.refine;

import cn.vertxup.jet.domain.tables.pojos.IService;
import io.horizon.eon.em.uca.AopType;
import io.horizon.spi.environment.Ambient;
import io.horizon.uca.cache.Cc;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.commune.exchange.BTree;
import io.vertx.up.commune.exchange.DSetting;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

class JtBusiness {
    private static final Cc<String, DSetting> CC_DICT = Cc.open();
    private static final Cc<String, BTree> CC_MAPPING = Cc.open();
    private static final Cc<String, Identity> CC_IDENTITY = Cc.open();

    JtBusiness() {
    }

    static DSetting toDict(IService service) {
        return (DSetting)Fn.runOr(null, () -> (DSetting)CC_DICT.pick(() -> {
            String dictStr = service.getDictConfig();
            DSetting dict = new DSetting(dictStr);
            if (!dict.getSource().isEmpty()) {
                Class component = Ut.clazz((String)service.getDictComponent(), null);
                dict.bind(component);
                JsonObject epsilonJson = Ut.toJObject((String)service.getDictEpsilon());
                dict.bind(Ux.dictEpsilon((JsonObject)epsilonJson));
            }
            return dict;
        }, (Object)service.getKey()), (Object[])new Object[]{service});
    }

    static BTree toMapping(IService service) {
        return (BTree)Fn.runOr(null, () -> (BTree)CC_MAPPING.pick(() -> {
            AopType mode = (AopType)Ut.toEnum(service::getMappingMode, AopType.class, (Enum)AopType.NONE);
            BTree mapping = new BTree();
            JsonObject config = Ut.toJObject((String)service.getMappingConfig());
            Class component = Ut.clazz((String)service.getMappingComponent(), null);
            mapping.init(config).bind(mode).bind(component);
            return mapping;
        }, (Object)service.getKey()), (Object[])new Object[]{service});
    }

    static Identity toIdentify(IService service) {
        return (Identity)Fn.runOr(null, () -> (Identity)CC_IDENTITY.pick(() -> {
            Identity identity = new Identity();
            identity.setIdentifier(service.getIdentifier());
            Class component = Ut.clazz((String)service.getIdentifierComponent(), null);
            identity.setIdentifierComponent(component);
            identity.setSigma(service.getSigma());
            return identity;
        }, (Object)service.getKey()), (Object[])new Object[]{service});
    }

    static Future<ConcurrentMap<String, JsonArray>> toDictionary(String key, String cacheKey, String identifier, DSetting dict) {
        MultiMap paramMap = MultiMap.caseInsensitiveMultiMap();
        paramMap.add("identifier", identifier);
        paramMap.add("cacheKey", cacheKey);
        JtApp app = Ambient.getApp(key);
        if (Objects.nonNull(app)) {
            paramMap.add("sigma", app.getSigma());
            paramMap.add("appId", app.getAppId());
        }
        return Ux.dictCalc((DSetting)dict, (MultiMap)paramMap);
    }
}

