/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.refine;

import cn.vertxup.jet.domain.tables.pojos.IApi;
import cn.vertxup.jet.domain.tables.pojos.IJob;
import cn.vertxup.jet.domain.tables.pojos.IService;
import io.aeon.experiment.rule.RuleUnique;
import io.horizon.eon.em.container.ChannelType;
import io.horizon.uca.log.Log;
import io.horizon.uca.log.LogModule;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.atom.JtConfig;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.atom.JtWorker;
import io.vertx.tp.jet.refine.JtBusiness;
import io.vertx.tp.jet.refine.JtDataObject;
import io.vertx.tp.jet.refine.JtDelivery;
import io.vertx.tp.jet.refine.JtRoute;
import io.vertx.tp.jet.refine.JtType;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.commune.exchange.BTree;
import io.vertx.up.commune.exchange.DSetting;
import jakarta.ws.rs.core.MediaType;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Jt {
    public static String jobCode(IJob job) {
        return job.getNamespace() + "-" + job.getCode();
    }

    public static String toPath(Supplier<String> routeSupplier, Supplier<String> uriSupplier, boolean secure, JtConfig external) {
        return JtRoute.toPath(routeSupplier, uriSupplier, secure, external);
    }

    public static String toPath(Supplier<String> routeSupplier, Supplier<String> uriSupplier, boolean secure) {
        return JtRoute.toPath(routeSupplier, uriSupplier, secure);
    }

    public static Set<MediaType> toMime(Supplier<String> supplier) {
        return JtRoute.toMime(supplier);
    }

    public static Set<String> toMimeString(Supplier<String> supplier) {
        return Jt.toMime(supplier).stream().map(type -> type.getType() + "/" + type.getSubtype()).collect(Collectors.toSet());
    }

    public static DSetting toDict(IService service) {
        return JtBusiness.toDict(service);
    }

    public static BTree toMapping(IService service) {
        return JtBusiness.toMapping(service);
    }

    public static Identity toIdentity(IService service) {
        return JtBusiness.toIdentify(service);
    }

    public static Future<ConcurrentMap<String, JsonArray>> toDictionary(String key, String cacheKey, String identifier, DSetting dict) {
        return JtBusiness.toDictionary(key, cacheKey, identifier, dict);
    }

    public static Set<String> toSet(Supplier<String> supplier) {
        return JtRoute.toSet(supplier);
    }

    public static JtWorker toWorker(IApi api) {
        return JtType.toWorker(api);
    }

    public static Class<?> toChannel(Supplier<String> supplier, ChannelType type) {
        return JtType.toChannel(supplier, type);
    }

    public static void initApi(IApi api) {
        JtDataObject.initApi(api);
    }

    public static JsonObject toOptions(JtApp app, IApi api, IService service) {
        return JtDataObject.toOptions(app, api, service);
    }

    public static JsonObject toOptions(JtApp app, IJob job, IService service) {
        return JtDataObject.toOptions(app, job, service);
    }

    public static JsonObject toOptions(JtApp app, IService service) {
        return JtDataObject.toOptions(app, service);
    }

    public static ConcurrentMap<String, JsonObject> ask(Set<JtUri> uriSet) {
        return JtDelivery.ask(uriSet);
    }

    public static ConcurrentMap<String, JtUri> answer(JsonObject config) {
        return JtDelivery.answer(config);
    }

    public static Database toDatabase(Supplier<String> supplier, Database defaultDatabase) {
        return JtDataObject.toDatabase(supplier, defaultDatabase);
    }

    public static Database toDatabase(IService service) {
        return JtDataObject.toDatabase(service);
    }

    public static RuleUnique toRule(IService service) {
        return JtDataObject.toRule(service);
    }

    public static Integration toIntegration(IService service) {
        return JtDataObject.toIntegration(service);
    }

    public static interface LOG {
        public static final String MODULE = "\u03a0\u03af\u03b4\u03b1\u03ba\u03b1\u03c2 \u03b4\u03c1\u03bf\u03bc\u03bf\u03bb\u03bf\u03b3\u03b7\u03c4\u03ae";
        public static final LogModule Init = Log.modulat((String)"\u03a0\u03af\u03b4\u03b1\u03ba\u03b1\u03c2 \u03b4\u03c1\u03bf\u03bc\u03bf\u03bb\u03bf\u03b3\u03b7\u03c4\u03ae").program("Init");
        public static final LogModule Route = Log.modulat((String)"\u03a0\u03af\u03b4\u03b1\u03ba\u03b1\u03c2 \u03b4\u03c1\u03bf\u03bc\u03bf\u03bb\u03bf\u03b3\u03b7\u03c4\u03ae").program("Route");
        public static final LogModule Worker = Log.modulat((String)"\u03a0\u03af\u03b4\u03b1\u03ba\u03b1\u03c2 \u03b4\u03c1\u03bf\u03bc\u03bf\u03bb\u03bf\u03b3\u03b7\u03c4\u03ae").program("Worker");
        public static final LogModule Web = Log.modulat((String)"\u03a0\u03af\u03b4\u03b1\u03ba\u03b1\u03c2 \u03b4\u03c1\u03bf\u03bc\u03bf\u03bb\u03bf\u03b3\u03b7\u03c4\u03ae").program("Web");
        public static final LogModule App = Log.modulat((String)"\u03a0\u03af\u03b4\u03b1\u03ba\u03b1\u03c2 \u03b4\u03c1\u03bf\u03bc\u03bf\u03bb\u03bf\u03b3\u03b7\u03c4\u03ae").program("App");
    }
}

