/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.monitor;

import io.horizon.uca.cache.Cc;
import io.horizon.uca.log.Annal;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.monitor.JtAtomic;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.util.Ut;

public class JtMonitor {
    private static final Cc<Class<?>, JtMonitor> CC_MONITOR = Cc.open();
    private final transient Annal logger;
    private final transient String name;
    private final transient JtAtomic atomic = new JtAtomic();

    private JtMonitor(Class<?> clazz) {
        this.name = clazz.getName();
        this.logger = Annal.get(clazz);
    }

    public static JtMonitor create(Class<?> clazz) {
        return (JtMonitor)CC_MONITOR.pick(() -> new JtMonitor(clazz), clazz);
    }

    public void agentConfig(JsonObject config) {
        this.atomic.start(this.logger, config);
    }

    public void workerStart() {
        this.atomic.worker(this.logger);
    }

    public void workerFailure() {
        this.atomic.workerFailure(this.logger);
    }

    public void workerDeploying(Integer instances, String name) {
        this.atomic.workerDeploying(this.logger, instances, name);
    }

    public void workerDeployed(Integer instances, String name) {
        this.atomic.workerDeployed(this.logger, instances, name);
    }

    public void receiveData(String identifier, JtUri uri) {
        Jt.LOG.Web.info(this.logger, "Api interface: id = {0}, method = {1}, path = {2}", new Object[]{identifier, uri.method(), uri.path()});
        Jt.LOG.Web.info(this.logger, "---> Api Json: {0}", new Object[]{((JsonObject)Ut.serializeJson((Object)uri.api())).encode()});
        Jt.LOG.Web.info(this.logger, "---> Service Json: {0}", new Object[]{((JsonObject)Ut.serializeJson((Object)uri.service())).encode()});
        Jt.LOG.Web.info(this.logger, "---> Worker Json: {0}", new Object[]{((JsonObject)Ut.serializeJson((Object)uri.worker())).encode()});
    }

    public void aimEngine(HttpMethod method, String path, JsonObject data) {
        Jt.LOG.Web.info(this.logger, "Web request: `{0} {1}`, params: {2}", new Object[]{method, path, data.encode()});
    }

    public void aimSend(JsonObject data, String address) {
        Jt.LOG.Web.info(this.logger, "Send data `{0}` to address = `{1}`", new Object[]{data.encode(), address});
    }

    public void channelHit(Class<?> clazz) {
        Jt.LOG.Web.info(this.logger, "Channel selected: class = {0}", new Object[]{null == clazz ? null : clazz.getName()});
    }

    public void componentHit(Class<?> componentClass, Class<?> recordClass) {
        Jt.LOG.Web.info(this.logger, "Component = {0}, Record = {1}", new Object[]{null == componentClass ? null : componentClass.getName(), null == recordClass ? null : recordClass.getName()});
    }
}

