/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.monitor;

import io.horizon.uca.log.Annal;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.runtime.Runner;
import java.util.concurrent.atomic.AtomicBoolean;

class JtAtomic {
    private static final AtomicBoolean AGENT_CONFIG = new AtomicBoolean(Boolean.FALSE);
    private static final AtomicBoolean WORKER_DEPLOY = new AtomicBoolean(Boolean.FALSE);
    private static final AtomicBoolean WORKER_FAILURE = new AtomicBoolean(Boolean.FALSE);
    private static final AtomicBoolean WORKER_DEPLOYING = new AtomicBoolean(Boolean.FALSE);
    private static final AtomicBoolean WORKER_DEPLOYED = new AtomicBoolean(Boolean.FALSE);

    JtAtomic() {
    }

    void start(Annal logger, JsonObject config) {
        if (!AGENT_CONFIG.getAndSet(Boolean.TRUE)) {
            Runner.run(() -> Jt.LOG.Route.info(logger, "Jet agent will begin `Routing System` with additional config = {0}", new Object[]{config.encode()}), (String)"jet-agent-config");
        }
    }

    void worker(Annal logger) {
        if (!WORKER_DEPLOY.getAndSet(Boolean.TRUE)) {
            Runner.run(() -> Jt.LOG.Worker.info(logger, "Workers will be deployed in background async ......", new Object[0]), (String)"jet-worker-deploy");
        }
    }

    void workerFailure(Annal logger) {
        if (!WORKER_FAILURE.getAndSet(Boolean.TRUE)) {
            Runner.run(() -> Jt.LOG.Worker.info(logger, "Ambient XHeader booting error, initialized failure", new Object[0]), (String)"jet-worker-failure");
        }
    }

    void workerDeploying(Annal logger, Integer instances, String name) {
        if (!WORKER_DEPLOYING.getAndSet(Boolean.TRUE)) {
            Runner.run(() -> Jt.LOG.Worker.info(logger, "Worker instance = {0}, class = {1}", new Object[]{String.valueOf(instances), name}), (String)"jet-worker-deploying");
        }
    }

    void workerDeployed(Annal logger, Integer instances, String name) {
        if (!WORKER_DEPLOYED.getAndSet(Boolean.TRUE)) {
            Runner.run(() -> Jt.LOG.Worker.info(logger, "Worker `{0}` has been deployed successfully!!! ( instance = {1} )", new Object[]{name, String.valueOf(instances)}), (String)"jet-worker-deployed");
        }
    }
}

