/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.atom;

import cn.vertxup.jet.domain.tables.pojos.IJob;
import cn.vertxup.jet.domain.tables.pojos.IService;
import io.aeon.experiment.specification.sch.KTimer;
import io.horizon.atom.app.KApp;
import io.horizon.eon.em.scheduler.JobType;
import io.horizon.spi.environment.Ambient;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.atom.JtCommercial;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class JtJob
extends JtCommercial {
    private transient IJob job;
    private transient String key;

    public JtJob() {
    }

    public JtJob(IJob job, IService service) {
        super(service);
        this.job = job;
        this.key = job.getKey();
    }

    public JsonObject options() {
        return Jt.toOptions(this.getApp(), this.job, this.service());
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public JsonObject toJson() {
        JsonObject data = super.toJson();
        data.put("job", (Object)Ut.serializeJson((Object)this.job));
        return data;
    }

    @Override
    public void fromJson(JsonObject data) {
        super.fromJson(data);
        this.key = data.getString("key");
        this.job = (IJob)Ut.deserialize((JsonObject)data.getJsonObject("job"), IJob.class);
    }

    public Mission toJob() {
        Mission mission = new Mission();
        mission.setName(this.job.getName());
        mission.setType((JobType)Ut.toEnum(this.job::getType, JobType.class, (Enum)JobType.ONCE));
        mission.setCode(Jt.jobCode(this.job));
        mission.setReadOnly(Boolean.FALSE.booleanValue());
        mission.setComment(this.job.getComment());
        mission.setAdditional(Ut.toJObject((String)this.job.getAdditional()));
        mission.setMetadata(this.toJson().copy());
        IService service = this.service();
        JtApp runtimeApp = Ambient.getApp(service.getSigma());
        KApp app = Objects.isNull(runtimeApp) ? KApp.instance().bind(service.getNamespace()).bind(service.getSigma(), service.getLanguage()) : KApp.instance((String)runtimeApp.getName()).bind(service.getNamespace()).bind(runtimeApp.getSigma(), runtimeApp.getLanguage());
        mission.app(app);
        mission.timeout(this.job.getThreshold(), TimeUnit.MINUTES);
        this.setTimer(mission);
        if (Objects.nonNull(this.job.getIncomeComponent())) {
            mission.setIncome(Ut.clazz((String)this.job.getIncomeComponent()));
        }
        mission.setIncomeAddress(this.job.getIncomeAddress());
        if (Objects.nonNull(this.job.getOutcomeComponent())) {
            mission.setOutcome(Ut.clazz((String)this.job.getOutcomeComponent()));
        }
        mission.setOutcomeAddress(this.job.getOutcomeAddress());
        return this.mount(mission);
    }

    private void setTimer(Mission mission) {
        KTimer timer = new KTimer(mission.getCode());
        String runFormula = this.job.getRunFormula();
        mission.detectPre(runFormula);
        JobType type = mission.getType();
        if (JobType.ONCE != type) {
            timer.scheduler(runFormula, this.job.getRunAt());
            if (Objects.nonNull(this.job.getDuration())) {
                timer.scheduler(this.job.getDuration().longValue(), TimeUnit.MINUTES);
            }
            mission.timer(timer);
        }
    }

    private Mission mount(Mission mission) {
        String proxyStr = this.job.getProxy();
        Class clazz = Ut.clazz((String)proxyStr);
        if (Objects.nonNull(clazz)) {
            return mission.connect(clazz);
        }
        return mission;
    }
}

