/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.atom;

import cn.vertxup.jet.domain.tables.pojos.IService;
import io.aeon.experiment.rule.RuleUnique;
import io.horizon.eon.em.Environment;
import io.horizon.eon.em.container.ChannelType;
import io.horizon.specification.meta.action.Commercial;
import io.horizon.spi.environment.Ambient;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.atom.JtConfig;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.commune.exchange.BTree;
import io.vertx.up.commune.exchange.DSetting;
import io.vertx.up.util.Ut;
import java.util.Objects;

public abstract class JtCommercial
implements Commercial {
    private transient Environment environment = Environment.Production;
    private transient IService service;
    private transient JtApp app;
    private transient JtConfig config;

    JtCommercial() {
    }

    JtCommercial(IService service) {
        this.service = service;
    }

    public <T extends JtCommercial> T bind(JtConfig config) {
        this.config = config;
        return (T)this;
    }

    public <T extends JtCommercial> T bind(String appId) {
        this.app = Ambient.getApp(appId);
        return (T)this;
    }

    public IService service() {
        return this.service;
    }

    protected JtApp getApp() {
        return this.app;
    }

    protected JtConfig getConfig() {
        return this.config;
    }

    public abstract String key();

    public ChannelType channelType() {
        return (ChannelType)Ut.toEnum(this.service::getChannelType, ChannelType.class, (Enum)ChannelType.ADAPTOR);
    }

    public Class<?> channelComponent() {
        return Jt.toChannel(this.service::getChannelComponent, this.channelType());
    }

    public Class<?> businessComponent() {
        return Ut.clazz((String)this.service.getServiceComponent());
    }

    public Class<?> recordComponent() {
        return Ut.clazz((String)this.service.getServiceRecord());
    }

    public Database database() {
        return Jt.toDatabase(this.service::getConfigDatabase, this.app.getSource());
    }

    public RuleUnique rule() {
        return Jt.toRule(this.service);
    }

    public Integration integration() {
        Integration integration = Jt.toIntegration(this.service);
        if (Environment.Mockito == this.environment) {
            integration.mockOn();
        }
        return integration;
    }

    public JtCommercial bind(Environment environment) {
        this.environment = environment;
        return this;
    }

    public DSetting dict() {
        return Jt.toDict(this.service);
    }

    public BTree mapping() {
        return Jt.toMapping(this.service);
    }

    public Identity identity() {
        return Jt.toIdentity(this.service);
    }

    public String app() {
        return this.app.getAppId();
    }

    public String identifier() {
        return this.service.getIdentifier();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JtUri)) {
            return false;
        }
        JtUri jtUri = (JtUri)o;
        return this.key().equals(jtUri.key());
    }

    public int hashCode() {
        return Objects.hash(this.key());
    }

    public JsonObject toJson() {
        JsonObject data = new JsonObject();
        data.put("key", (Object)this.key());
        JsonObject serviceJson = (JsonObject)Ut.serializeJson((Object)this.service());
        data.put("service", (Object)serviceJson);
        data.put("config", (Object)((JsonObject)Ut.serializeJson((Object)this.config)));
        data.put("appId", (Object)this.app.getAppId());
        data.put("__class", (Object)this.getClass().getName());
        return data;
    }

    public void fromJson(JsonObject data) {
        this.service = (IService)Ut.deserialize((JsonObject)data.getJsonObject("service"), IService.class);
        this.config = (JtConfig)Ut.deserialize((JsonObject)data.getJsonObject("config"), JtConfig.class);
        String appId = data.getString("appId");
        this.app = Ambient.getApp(appId);
    }
}

