/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.Pool;
import io.vertx.tp.jet.atom.JtConfig;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.atom.JtWorker;
import io.vertx.tp.jet.cv.em.WorkerType;
import io.vertx.tp.jet.init.JtPin;
import io.vertx.tp.jet.monitor.JtMonitor;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.uca.log.DevOps;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class JetCastor {
    private final transient Vertx vertx;
    private final transient JtMonitor monitor = JtMonitor.create(this.getClass());

    private JetCastor(Vertx vertx) {
        this.vertx = vertx;
    }

    public static JetCastor create(Vertx vertx) {
        return new JetCastor(vertx);
    }

    void startWorkers(Set<JtUri> uriSet) {
        uriSet.stream().map(JtUri::worker).filter(worker -> WorkerType.JS != worker.getWorkerType()).map(JtWorker::getWorkerClass).forEach(Pool.WORKER_SET::add);
        ConcurrentMap<String, JsonObject> config = Jt.ask(uriSet);
        JtConfig configData = JtPin.getConfig();
        Pool.WORKER_SET.forEach(workerCls -> {
            String name = workerCls.getName();
            DeploymentOptions options = configData.getWorkerOptions();
            JsonObject deliveryConfig = (JsonObject)config.get(name);
            options.setConfig(deliveryConfig);
            this.monitor.workerDeploying(options.getInstances(), name);
            this.vertx.deployVerticle(name, options, handler -> {
                if (handler.succeeded()) {
                    this.monitor.workerDeployed(options.getInstances(), name);
                    DevOps.on((Vertx)this.vertx).add(name, options, (String)handler.result());
                } else if (Objects.nonNull(handler.cause())) {
                    handler.cause().printStackTrace();
                }
            });
        });
    }
}

