/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.business;

import cn.vertxup.jet.domain.tables.daos.IApiDao;
import io.horizon.spi.environment.Ambient;
import io.horizon.spi.web.Routine;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.runtime.soul.UriMeta;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExRouteApi
implements Routine {
    public Future<List<UriMeta>> searchAsync(String keyword, String sigma) {
        if (Ut.isNil((String)keyword) || Ut.isNil((String)sigma)) {
            return Ux.future(new ArrayList());
        }
        JtApp app = Ambient.getApp(sigma);
        if (Objects.isNull(app)) {
            return Ux.future(new ArrayList());
        }
        JsonObject condition = new JsonObject();
        condition.put("sigma", (Object)sigma);
        JsonObject criteria = new JsonObject();
        criteria.put("name,c", (Object)keyword);
        criteria.put("comment,c", (Object)keyword);
        criteria.put("uri,c", (Object)keyword);
        condition.put("$0", (Object)criteria);
        return Ux.Jooq.on(IApiDao.class).fetchAndAsync(condition).compose(apis -> {
            ArrayList uris = new ArrayList();
            apis.forEach(api -> {
                UriMeta meta = new UriMeta();
                meta.setDynamic(Boolean.TRUE.booleanValue());
                meta.setKey(api.getKey());
                String uri = Jt.toPath(app::getRoute, api::getUri, api.getSecure());
                meta.setUri(uri);
                meta.setMethod(Ut.toMethod(api::getMethod));
                meta.setName(api.getName());
                meta.setComment(api.getComment());
                uris.add(meta);
            });
            return Ux.future(uris);
        });
    }
}

