/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.jet.service;

import cn.vertxup.cache.AmbientStub;
import cn.vertxup.jet.domain.tables.daos.IJobDao;
import cn.vertxup.jet.domain.tables.daos.IServiceDao;
import cn.vertxup.jet.domain.tables.pojos.IJob;
import cn.vertxup.jet.domain.tables.pojos.IService;
import cn.vertxup.jet.service.JobKit;
import cn.vertxup.jet.service.JobStub;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class JobService
implements JobStub {
    private static final Annal LOGGER = Annal.get(JobService.class);
    @Inject
    private transient AmbientStub ambient;

    @Override
    public Future<JsonObject> searchJobs(String sigma, JsonObject body, boolean grouped) {
        Qr qr = Qr.create((JsonObject)body);
        qr.getCriteria().save("sigma", (Object)sigma);
        JsonObject condition = qr.toJson();
        LOGGER.info("Job condition: {0}", new Object[]{condition});
        return Ux.Jooq.on(IJobDao.class).searchAsync(condition).compose(jobs -> {
            List jobList = Ux.fromPage((JsonObject)jobs, IJob.class);
            Set<String> codes = jobList.stream().filter(Objects::nonNull).map(Jt::jobCode).collect(Collectors.toSet());
            Jt.LOG.Web.info(LOGGER, "Job fetched from database: {0}, input sigma: {1}", new Object[]{codes.size(), sigma});
            return JobKit.fetchMission(codes).compose(normalized -> {
                jobs.put("list", normalized);
                if (grouped) {
                    JsonObject criteria = qr.getCriteria().toJson();
                    return Ux.Jooq.on(IJobDao.class).countByAsync(criteria, "group").compose(aggregation -> {
                        JsonObject aggregationJson = new JsonObject();
                        aggregation.forEach((arg_0, arg_1) -> ((JsonObject)aggregationJson).put(arg_0, arg_1));
                        jobs.put("aggregation", (Object)aggregationJson);
                        return Ux.future((Object)jobs);
                    });
                }
                return Ux.future((Object)jobs);
            });
        });
    }

    @Override
    public Future<JsonObject> fetchByKey(String key) {
        return Ux.Jooq.on(IJobDao.class).fetchByIdAsync((Object)key).compose(Fn.ofJObject(job -> JobKit.fetchMission(Jt.jobCode(job))));
    }

    @Override
    public Future<JsonObject> update(String key, JsonObject data) {
        JsonObject serviceJson = data.getJsonObject("service");
        if (Ut.isNil((JsonObject)serviceJson)) {
            serviceJson = new JsonObject();
        } else {
            serviceJson = serviceJson.copy();
            data.remove("service");
        }
        IJob job = (IJob)Ux.fromJson((JsonObject)data, IJob.class);
        IService service = JobKit.fromJson(serviceJson);
        return Ux.Jooq.on(IJobDao.class).upsertAsync((Object)job.getKey(), (Object)job).compose(updatedJob -> Ux.Jooq.on(IServiceDao.class).upsertAsync((Object)service.getKey(), (Object)service).compose(updatedSev -> this.ambient.updateJob((IJob)updatedJob, (IService)updatedSev)));
    }
}

