/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.jet.service;

import cn.vertxup.jet.domain.tables.pojos.IService;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.uca.job.plugin.JobClient;
import io.vertx.up.uca.job.plugin.JobInfix;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;

public class JobKit {
    private static final JobClient CLIENT = JobInfix.getClient();

    static Future<JsonArray> fetchMission(Set<String> codes) {
        if (Objects.isNull(CLIENT)) {
            return Ux.futureA();
        }
        return CLIENT.fetchAsync(codes).compose(missionList -> {
            JsonArray response = new JsonArray();
            missionList.forEach(item -> response.add((Object)JobKit.toJson(item)));
            return Ux.future((Object)response);
        });
    }

    static Future<JsonObject> fetchMission(String code) {
        if (Objects.isNull(CLIENT)) {
            return Ux.futureJ();
        }
        return CLIENT.fetchAsync(code).compose(found -> {
            if (Objects.isNull(found)) {
                return Ux.future((Object)new JsonObject());
            }
            return Ux.future((Object)JobKit.toJson(found));
        });
    }

    public static IService fromJson(JsonObject serviceJson) {
        Ut.valueToString((JsonObject)serviceJson, (String[])new String[]{"metadata", "ruleUnique", "configIntegration", "configDatabase", "channelConfig", "serviceConfig", "mappingConfig", "dictEpsilon", "dictConfig"});
        return (IService)Ux.fromJson((JsonObject)serviceJson, IService.class);
    }

    public static JsonObject toJson(Mission mission) {
        JsonObject service;
        JsonObject serialized = (JsonObject)Ut.serializeJson((Object)mission);
        JsonObject metadata = serialized.getJsonObject("metadata");
        if (Ut.isNotNil((JsonObject)metadata) && Ut.isNotNil((JsonObject)(service = metadata.getJsonObject("service")))) {
            Ut.valueToJObject((JsonObject)service, (String[])new String[]{"metadata", "ruleUnique", "configIntegration", "configDatabase", "channelConfig", "serviceConfig", "mappingConfig", "dictEpsilon", "dictConfig"});
        }
        return serialized;
    }
}

