/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.environment;

import cn.vertxup.jet.domain.tables.daos.IApiDao;
import cn.vertxup.jet.domain.tables.daos.IJobDao;
import cn.vertxup.jet.domain.tables.daos.IServiceDao;
import cn.vertxup.jet.domain.tables.pojos.IApi;
import cn.vertxup.jet.domain.tables.pojos.IJob;
import cn.vertxup.jet.domain.tables.pojos.IService;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.atom.JtJob;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.tp.optic.environment.Ambient;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.commune.config.Database;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AmbientEnvironment {
    private static final Annal LOGGER = Annal.get(Ambient.class);
    private final transient ConcurrentMap<String, JtJob> jobs = new ConcurrentHashMap<String, JtJob>();
    private final transient ConcurrentMap<String, JtUri> uris = new ConcurrentHashMap<String, JtUri>();
    private final transient JtApp app;
    private final transient Set<String> condition = new HashSet<String>();
    private final transient DataPool pool;
    private final transient DataPool poolMeta;
    private final ConcurrentMap<String, IService> serviceMap = new ConcurrentHashMap<String, IService>();

    AmbientEnvironment(JtApp app) {
        this.app = app;
        this.condition.add(app.getSigma());
        this.pool = DataPool.create((Database)app.getSource());
        this.poolMeta = DataPool.create((Database)Database.getCurrent());
    }

    @Fluent
    public Future<AmbientEnvironment> init(Vertx vertx) {
        return this.initService(vertx).compose(nil -> {
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
            futures.add(this.initUris(vertx));
            futures.add(this.initJobs(vertx));
            return Ux.thenCombineT(futures).compose(res -> Ux.future((Object)this));
        });
    }

    private Future<Boolean> initService(Vertx vertx) {
        IServiceDao serviceDao = new IServiceDao(this.poolMeta.getExecutor().configuration(), vertx);
        return serviceDao.findManyBySigma(this.condition).compose(services -> {
            this.serviceMap.putAll(Ut.elementZip((Collection)services, IService::getKey, service -> service));
            Jt.infoInit(LOGGER, "AE ( {0} ) Service initialized !!!", String.valueOf(this.serviceMap.keySet().size()));
            return Ux.future((Object)Boolean.TRUE);
        });
    }

    private Future<Boolean> initJobs(Vertx vertx) {
        IJobDao jobDao = new IJobDao(this.poolMeta.getExecutor().configuration(), vertx);
        if (this.jobs.isEmpty()) {
            return jobDao.findManyBySigma(this.condition).compose(jobList -> {
                ConcurrentMap jobMap = Ut.elementZip((Collection)jobList, IJob::getServiceId, job -> job);
                jobMap.keySet().stream().map(serviceId -> (JtJob)new JtJob((IJob)jobMap.get(serviceId), (IService)this.serviceMap.get(serviceId)).bind(this.app.getAppId())).forEach(entry -> this.jobs.put(entry.key(), (JtJob)entry));
                Jt.infoInit(LOGGER, "AE ( {0} ) Jobs initialized !!!", String.valueOf(this.jobs.keySet().size()));
                return Ux.future((Object)Boolean.TRUE);
            });
        }
        return Ux.future((Object)Boolean.TRUE);
    }

    private Future<Boolean> initUris(Vertx vertx) {
        IApiDao apiDao = new IApiDao(this.poolMeta.getExecutor().configuration(), vertx);
        if (this.uris.isEmpty()) {
            return apiDao.findManyBySigma(this.condition).compose(apiList -> {
                ConcurrentMap apiMap = Ut.elementZip((Collection)apiList, IApi::getServiceId, api -> api);
                apiMap.keySet().stream().map(serviceId -> (JtUri)new JtUri((IApi)apiMap.get(serviceId), (IService)this.serviceMap.get(serviceId)).bind(this.app.getAppId())).forEach(entry -> this.uris.put(entry.key(), (JtUri)entry));
                Jt.infoInit(LOGGER, "AE ( {0} ) Api initialized !!!", String.valueOf(this.uris.keySet().size()));
                return Ux.future((Object)Boolean.TRUE);
            });
        }
        return Ux.future((Object)Boolean.TRUE);
    }

    public Connection getConnection() {
        return (Connection)Fn.getJvm(() -> this.pool.getDataSource().getConnection(), (Object[])new Object[]{this.pool});
    }

    public DataPool getPool() {
        return this.pool;
    }

    public Set<JtUri> routes() {
        return new HashSet<JtUri>(this.uris.values());
    }

    public Set<JtJob> jobs() {
        return new HashSet<JtJob>(this.jobs.values());
    }

    public void flushJob(JtJob job) {
        IService service = job.service();
        this.serviceMap.put(service.getKey(), service);
        this.jobs.put(service.getKey(), job);
    }

    public void flushUri(JtUri uri) {
        IService service = uri.service();
        this.serviceMap.put(service.getKey(), service);
        this.uris.put(service.getKey(), uri);
    }
}

