/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.environment;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._500AmbientConnectException;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.init.JtPin;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.tp.optic.environment.AmbientEnvironment;
import io.vertx.tp.optic.environment.UnityApp;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Ambient {
    private static final ConcurrentMap<String, JtApp> APPS = new ConcurrentHashMap<String, JtApp>();
    private static final ConcurrentMap<String, AmbientEnvironment> ENVIRONMENTS = new ConcurrentHashMap<String, AmbientEnvironment>();
    private static final Annal LOGGER = Annal.get(Ambient.class);

    public static Future<Boolean> init(Vertx vertx) {
        try {
            UnityApp unity = JtPin.getUnity();
            Fn.out((null == unity ? 1 : 0) != 0, _500AmbientConnectException.class, (Object[])new Object[]{Ambient.class});
            return unity.initialize(vertx).compose(initialized -> {
                ConcurrentMap unityData = unity.connect();
                unityData.forEach((key, json) -> APPS.put((String)key, (JtApp)Ut.deserialize((JsonObject)json, JtApp.class)));
                Jt.infoInit(LOGGER, "Ambient detect {0} applications in your environment.", String.valueOf(APPS.keySet().size()));
                if (APPS.isEmpty()) {
                    Jt.warnInfo(LOGGER, "Ambient environment pool is Empty.", new Object[0]);
                }
                ConcurrentHashMap futures = new ConcurrentHashMap();
                APPS.forEach((appId, app) -> futures.put(appId, new AmbientEnvironment((JtApp)app).init(vertx)));
                return Ux.thenCombine(futures).compose(processed -> {
                    ENVIRONMENTS.putAll((Map<String, AmbientEnvironment>)processed);
                    Jt.infoInit(LOGGER, "AmbientEnvironment initialized !!!", new Object[0]);
                    return Ux.future((Object)Boolean.TRUE);
                });
            });
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return Future.failedFuture((Throwable)ex);
        }
    }

    public static ConcurrentMap<String, AmbientEnvironment> getEnvironments() {
        return ENVIRONMENTS;
    }

    public static JtApp getCurrent(MultiMap headers) {
        String appKey;
        String appId = headers.get("X-App-Id");
        if (Ut.notNil((String)appId)) {
            return (JtApp)APPS.get(appId);
        }
        String sigma = headers.get("X-Sigma");
        JtApp app = null;
        if (Ut.notNil((String)sigma)) {
            app = Ambient.searchApp(sigma, JtApp::getSigma);
        }
        if (Objects.isNull(app) && Ut.notNil((String)(appKey = headers.get("X-App-Key")))) {
            app = Ambient.searchApp(sigma, JtApp::getAppKey);
        }
        return app;
    }

    public static JtApp getApp(String key) {
        if (Ut.isNil((String)key)) {
            Jt.warnApp(LOGGER, "Input key of app is null, key = {0}", key);
            Jt.warnApp(LOGGER, "You may missed the configuration of `io.vertx.tp.jet.init.JtPin` to on `init` node. ", new Object[0]);
            return null;
        }
        JtApp app = (JtApp)APPS.get(key);
        if (Objects.isNull(app)) {
            app = Ambient.searchApp(key, JtApp::getSigma);
        }
        return app;
    }

    private static JtApp searchApp(String key, Function<JtApp, String> executor) {
        JtApp app = APPS.values().stream().filter(Objects::nonNull).filter(appItem -> key.equals(executor.apply((JtApp)appItem))).findFirst().orElse(null);
        if (Objects.isNull(app)) {
            Jt.warnApp(LOGGER, "Ambient -> JtApp = null, input key = {0}", key);
        }
        return app;
    }
}

