/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.uca.tunnel;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.optic.jet.JtComponent;
import io.vertx.up.commune.Commercial;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.commune.exchange.BiTree;
import io.vertx.up.commune.exchange.DiFabric;
import io.vertx.up.commune.rule.RuleUnique;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Supplier;

class Anagogic {
    Anagogic() {
    }

    static Future<Database> databaseAsync(Commercial commercial) {
        return Rapid.t((String)"ZERO-CACHE_MULTI_DATABASE").cached((Object)commercial.app(), () -> Ux.future((Object)commercial.database()));
    }

    static Future<Boolean> componentAsync(JtComponent component, Envelop envelop) {
        JsonObject headers = envelop.headersX();
        XHeader header = new XHeader();
        header.fromJson(headers);
        Ut.contract((Object)component, XHeader.class, (Object)header);
        return Ux.future((Object)Boolean.TRUE);
    }

    static Future<Boolean> componentAsync(JtComponent component, Commercial commercial, Supplier<Future<DiFabric>> supplier) {
        if (Objects.nonNull(commercial)) {
            return supplier.get().compose(fabric -> {
                JsonObject options = Ut.valueJObject((JsonObject)commercial.options());
                Ut.contract((Object)component, JsonObject.class, (Object)options);
                Ut.contract((Object)component, Identity.class, (Object)commercial.identity());
                Ut.contract((Object)component, BiTree.class, (Object)commercial.mapping());
                Ut.contract((Object)component, DiFabric.class, (Object)fabric);
                Ut.contract((Object)component, RuleUnique.class, (Object)commercial.rule());
                return Future.succeededFuture((Object)Boolean.TRUE);
            });
        }
        return Future.succeededFuture((Object)Boolean.TRUE);
    }
}

