/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.uca.tunnel;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.error._501ChannelErrorException;
import io.vertx.tp.jet.monitor.JtMonitor;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.tp.jet.uca.tunnel.Anagogic;
import io.vertx.tp.optic.jet.JtChannel;
import io.vertx.tp.optic.jet.JtComponent;
import io.vertx.up.annotations.Contract;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.commune.ActIn;
import io.vertx.up.commune.ActOut;
import io.vertx.up.commune.Commercial;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.exchange.DiFabric;
import io.vertx.up.commune.exchange.DiSetting;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractChannel
implements JtChannel {
    private final transient JtMonitor monitor = JtMonitor.create(this.getClass());
    @Contract
    private transient Commercial commercial;
    @Contract
    private transient Mission mission;
    @Contract
    private transient ConcurrentMap<String, JsonArray> dictionary;

    @Override
    public Future<Envelop> transferAsync(Envelop envelop) {
        Class recordClass = this.commercial.recordComponent();
        Class componentClass = this.commercial.businessComponent();
        if (Objects.isNull(componentClass)) {
            return Future.failedFuture((Throwable)((Object)new _501ChannelErrorException(this.getClass(), null)));
        }
        return this.createRequest(envelop, recordClass).compose(request -> {
            JtComponent component = (JtComponent)Ut.instance((Class)componentClass, (Object[])new Object[0]);
            if (Objects.nonNull(component)) {
                this.monitor.componentHit(componentClass, recordClass);
                Ux.debug((Object[])new Object[0]);
                return this.initAsync(component, (ActIn)request).compose(initialized -> Anagogic.componentAsync(component, this.commercial, this::createFabric)).compose(initialized -> Anagogic.componentAsync(component, envelop)).compose(initialized -> component.transferAsync((ActIn)request)).compose(actOut -> this.createResponse((ActOut)actOut, envelop)).otherwise(Ux.otherwise());
            }
            return Future.failedFuture((Throwable)((Object)new _501ChannelErrorException(this.getClass(), componentClass.getName())));
        });
    }

    private Future<Envelop> createResponse(ActOut actOut, Envelop envelop) {
        return Ux.future((Object)actOut.envelop(this.commercial.mapping()).from(envelop));
    }

    private Future<ActIn> createRequest(Envelop envelop, Class<?> recordClass) {
        Record definition = (Record)Ut.instance(recordClass, (Object[])new Object[0]);
        ActIn request = new ActIn(envelop);
        request.bind(this.commercial.mapping());
        request.connect(definition);
        return Ux.future((Object)request);
    }

    private Future<DiFabric> createFabric() {
        DiSetting dict = this.commercial.dict();
        if (Objects.isNull(this.dictionary)) {
            String appKey = this.commercial.app();
            String identifier = this.commercial.identifier();
            return Jt.toDictionary(appKey, identifier, dict).compose(dictionary -> {
                this.dictionary = dictionary;
                return Ux.future((Object)DiFabric.create().dictionary(dictionary).epsilon(dict.getEpsilon()));
            });
        }
        return Ux.future((Object)DiFabric.create().dictionary(this.dictionary).epsilon(dict.getEpsilon()));
    }

    public abstract Future<Boolean> initAsync(JtComponent var1, ActIn var2);

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }

    protected Commercial commercial() {
        return this.commercial;
    }

    protected Mission mission() {
        return this.mission;
    }
}

