/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.uca.param;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.cv.em.ParamMode;
import io.vertx.tp.jet.monitor.JtMonitor;
import io.vertx.tp.jet.uca.param.Pool;
import io.vertx.tp.jet.uca.param.Verifier;
import io.vertx.tp.optic.jet.JtIngest;
import io.vertx.up.commune.Envelop;
import java.util.Objects;
import java.util.function.Supplier;

public class DataIngest
implements JtIngest {
    private final transient JtMonitor monitor = JtMonitor.create(this.getClass());

    @Override
    public Envelop in(RoutingContext context, JtUri uri) {
        ParamMode mode = uri.paramMode();
        Supplier supplier = (Supplier)Pool.INNER_INGEST.get((Object)mode);
        assert (null != supplier) : "Function must not be null here.";
        JtIngest ingest = (JtIngest)supplier.get();
        Envelop envelop = ingest.in(context, uri);
        JsonObject params = (JsonObject)envelop.data();
        Envelop error = this.validate(envelop, uri);
        return Objects.isNull(error) ? envelop : error;
    }

    private Envelop validate(Envelop envelop, JtUri uri) {
        JsonObject data = (JsonObject)envelop.data();
        Envelop error = Verifier.validateRequired(this.getClass(), data, uri.paramRequired());
        ParamMode mode = uri.paramMode();
        if ((ParamMode.BODY == mode || ParamMode.DEFINE == mode) && null == error) {
            error = Verifier.validateContained(this.getClass(), data, uri.paramContained());
        }
        return error;
    }
}

