/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.uca.micro;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.eventbus.EventBus;
import io.vertx.tp.jet.JetThanatos;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.monitor.JtMonitor;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.tp.jet.uca.micro.Pool;
import io.vertx.tp.optic.jet.JtConsumer;
import io.vertx.up.commune.Envelop;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JtMinos
extends AbstractVerticle {
    private final transient JetThanatos ensurer = JetThanatos.create(((Object)((Object)this)).getClass());
    private final transient JtMonitor monitor = JtMonitor.create(((Object)((Object)this)).getClass());

    public void start() {
        EventBus event = this.vertx.eventBus();
        ConcurrentMap<String, JtUri> uriMap = Jt.answer(this.config());
        this.consumeAddr(uriMap).forEach((address, executor) -> event.consumer(address, handler -> {
            Envelop message = (Envelop)handler.body();
            JtUri uri = (JtUri)uriMap.get(message.key());
            if (Objects.isNull(uri)) {
                handler.reply((Object)this.ensurer.to500DefinitionError(message.key()));
            } else {
                this.monitor.receiveData(message.key(), uri);
                Future<Envelop> future = executor.async(message, uri);
                future.onComplete(replyHandler -> {
                    if (replyHandler.succeeded()) {
                        Envelop replied = (Envelop)replyHandler.result();
                        if (Objects.nonNull(replied.error())) {
                            replied.error().printStackTrace();
                        }
                        handler.reply((Object)replied);
                    } else {
                        handler.reply((Object)Envelop.failure((Throwable)replyHandler.cause()));
                    }
                });
            }
        }));
    }

    private ConcurrentMap<String, JtConsumer> consumeAddr(ConcurrentMap<String, JtUri> uriMap) {
        ConcurrentHashMap<String, JtConsumer> consumers = new ConcurrentHashMap<String, JtConsumer>();
        uriMap.values().stream().map(JtUri::worker).forEach(worker -> {
            String address = worker.getWorkerAddress();
            Class<?> consumerCls = worker.getWorkerConsumer();
            JtConsumer consumer = (JtConsumer)Fn.poolThread(Pool.CONSUMER_CLS, () -> (JtConsumer)Ut.instance((Class)consumerCls, (Object[])new Object[0]));
            if (Ut.notNil((String)address) && Objects.nonNull(consumer)) {
                consumers.put(address, consumer);
            }
        });
        return consumers;
    }
}

