/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.uca.business;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._501NotImplementException;
import io.vertx.tp.optic.jet.JtComponent;
import io.vertx.up.annotations.Contract;
import io.vertx.up.commune.ActIn;
import io.vertx.up.commune.ActOut;
import io.vertx.up.commune.Service;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.commune.exchange.BiTree;
import io.vertx.up.commune.exchange.DiFabric;
import io.vertx.up.commune.rule.RuleUnique;
import io.vertx.up.exception.web._400SigmaMissingException;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public abstract class AbstractComponent
implements JtComponent,
Service {
    @Contract
    protected transient XHeader header;
    @Contract
    protected transient DiFabric fabric;
    @Contract
    private transient JsonObject options;
    @Contract
    private transient Identity identity;
    @Contract
    private transient BiTree mapping;
    @Contract
    private transient RuleUnique rule;

    public JsonObject options() {
        return Objects.isNull(this.options) ? new JsonObject() : this.options.copy();
    }

    public Identity identity() {
        return this.identity;
    }

    public BiTree mapping() {
        return this.mapping;
    }

    public RuleUnique rule() {
        return this.rule;
    }

    protected Future<ActOut> transferAsync(ActIn request, Function<String, Future<ActOut>> executor) {
        String sigma = request.sigma();
        if (Ut.isNil((String)sigma)) {
            _400SigmaMissingException error = new _400SigmaMissingException(this.getClass());
            return ActOut.future((Throwable)error);
        }
        return executor.apply(sigma);
    }

    @Override
    public Future<ActOut> transferAsync(ActIn actIn) {
        _501NotImplementException error = new _501NotImplementException(this.getClass());
        return Future.failedFuture((Throwable)((Object)error));
    }

    protected <T> void contract(T instance) {
        if (Objects.nonNull(instance)) {
            Ut.contract(instance, JsonObject.class, (Object)this.options());
            Ut.contract(instance, Identity.class, (Object)this.identity());
            Ut.contract(instance, BiTree.class, (Object)this.mapping());
            Ut.contract(instance, DiFabric.class, (Object)this.fabric);
            Ut.contract(instance, XHeader.class, (Object)this.header);
            Ut.contract(instance, RuleUnique.class, (Object)this.rule);
        }
    }

    protected DiFabric fabric(JsonObject configured) {
        ConcurrentMap compiled = Ux.dictEpsilon((JsonObject)configured);
        return this.fabric.copy().epsilon(compiled);
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }
}

