/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.refine;

import cn.vertxup.jet.domain.tables.pojos.IService;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.refine.Pool;
import io.vertx.tp.optic.environment.Ambient;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.commune.exchange.BiTree;
import io.vertx.up.commune.exchange.DiSetting;
import io.vertx.up.eon.em.MappingMode;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

class JtBusiness {
    JtBusiness() {
    }

    static DiSetting toDict(IService service) {
        return (DiSetting)Fn.getNull(null, () -> (DiSetting)Fn.pool(Pool.POOL_DICT, (Object)service.getKey(), () -> {
            String dictStr = service.getDictConfig();
            DiSetting dict = new DiSetting(dictStr);
            if (!dict.getSource().isEmpty()) {
                Class component = Ut.clazz((String)service.getDictComponent(), null);
                dict.bind(component);
                JsonObject epsilonJson = Ut.toJObject((String)service.getDictEpsilon());
                dict.bind(Ux.dictEpsilon((JsonObject)epsilonJson));
            }
            return dict;
        }), (Object[])new Object[]{service});
    }

    static BiTree toMapping(IService service) {
        return (BiTree)Fn.getNull(null, () -> (BiTree)Fn.pool(Pool.POOL_MAPPING, (Object)service.getKey(), () -> {
            MappingMode mode = (MappingMode)Ut.toEnum(service::getMappingMode, MappingMode.class, (Enum)MappingMode.NONE);
            BiTree mapping = new BiTree();
            JsonObject config = Ut.toJObject((String)service.getMappingConfig());
            Class component = Ut.clazz((String)service.getMappingComponent(), null);
            mapping.init(config).bind(mode).bind(component);
            return mapping;
        }), (Object[])new Object[]{service});
    }

    static Identity toIdentify(IService service) {
        return (Identity)Fn.getNull(null, () -> (Identity)Fn.pool(Pool.POOL_IDENTITY, (Object)service.getKey(), () -> {
            Identity identity = new Identity();
            identity.setIdentifier(service.getIdentifier());
            Class component = Ut.clazz((String)service.getIdentifierComponent(), null);
            identity.setIdentifierComponent(component);
            identity.setSigma(service.getSigma());
            return identity;
        }), (Object[])new Object[]{service});
    }

    static Future<ConcurrentMap<String, JsonArray>> toDictionary(String key, String identifier, DiSetting dict) {
        MultiMap paramMap = MultiMap.caseInsensitiveMultiMap();
        paramMap.add("identifier", identifier);
        JtApp app = Ambient.getApp(key);
        if (Objects.nonNull(app)) {
            paramMap.add("sigma", app.getSigma());
            paramMap.add("appId", app.getAppId());
        }
        return Ux.dictCalc((DiSetting)dict, (MultiMap)paramMap);
    }
}

