/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.monitor;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.monitor.JtAtomic;
import io.vertx.tp.jet.monitor.Pool;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;

public class JtMonitor {
    private final transient Annal logger;
    private final transient String name;
    private final transient JtAtomic atomic = new JtAtomic();

    private JtMonitor(Class<?> clazz) {
        this.name = clazz.getName();
        this.logger = Annal.get(clazz);
    }

    public static JtMonitor create(Class<?> clazz) {
        return (JtMonitor)Fn.pool(Pool.MONITORS, clazz, () -> new JtMonitor(clazz));
    }

    public void agentConfig(JsonObject config) {
        this.atomic.start(this.logger, config);
    }

    public void workerStart() {
        this.atomic.worker(this.logger);
    }

    public void workerFailure() {
        this.atomic.workerFailure(this.logger);
    }

    public void workerDeploying(Integer instances, String name) {
        this.atomic.workerDeploying(this.logger, instances, name);
    }

    public void workerDeployed(Integer instances, String name) {
        this.atomic.workerDeployed(this.logger, instances, name);
    }

    public void receiveData(String identifier, JtUri uri) {
        Jt.infoWeb(this.logger, "Api interface: id = {0}, method = {1}, path = {2}", identifier, uri.method(), uri.path());
        Jt.infoWeb(this.logger, "---> Api Json: {0}", ((JsonObject)Ut.serializeJson((Object)uri.api())).encode());
        Jt.infoWeb(this.logger, "---> Service Json: {0}", ((JsonObject)Ut.serializeJson((Object)uri.service())).encode());
        Jt.infoWeb(this.logger, "---> Worker Json: {0}", ((JsonObject)Ut.serializeJson((Object)uri.worker())).encode());
    }

    public void aimEngine(HttpMethod method, String path, JsonObject data) {
        Jt.infoWeb(this.logger, "Web request: `{0} {1}`, params: {2}", method, path, data.encode());
    }

    public void aimSend(JsonObject data, String address) {
        Jt.infoWeb(this.logger, "Send data `{0}` to address = `{1}`", data.encode(), address);
    }

    public void channelHit(Class<?> clazz) {
        Jt.infoWeb(this.logger, "Channel selected: class = {0}", null == clazz ? null : clazz.getName());
    }

    public void componentHit(Class<?> componentClass, Class<?> recordClass) {
        Jt.infoWeb(this.logger, "Component = {0}, Record = {1}", null == componentClass ? null : componentClass.getName(), null == recordClass ? null : recordClass.getName());
    }
}

