/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.init;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtConfig;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.environment.Ambient;
import io.vertx.tp.optic.environment.UnityApp;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;
import java.util.Objects;

public class JtPin {
    private static final String KEY_ROUTER = "router";
    private static final Node<JsonObject> VISITOR = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static final Annal LOGGER = Annal.get(JtPin.class);
    private static JtConfig CONFIG = null;

    static void initializing() {
        JsonObject configData;
        if (null == CONFIG && (configData = (JsonObject)VISITOR.read()).containsKey(KEY_ROUTER)) {
            JsonObject router = configData.getJsonObject(KEY_ROUTER);
            Jt.infoInit(LOGGER, "Jt Router Json: {0}", router.encode());
            CONFIG = (JtConfig)Ut.deserialize((JsonObject)router, JtConfig.class);
            Jt.infoInit(LOGGER, "Jt Configuration: {0}", CONFIG.toString());
            Jt.infoInit(LOGGER, "---> Jt @Wall for `{0}`", CONFIG.getWall());
        }
    }

    public static Future<Boolean> init(Vertx vertx) {
        Ke.banner((String)"\u300c\u03a0\u03af\u03b4\u03b1\u03ba\u03b1\u03c2 \u03b4\u03c1\u03bf\u03bc\u03bf\u03bb\u03bf\u03b3\u03b7\u03c4\u03ae\u300d- ( Api )");
        Jt.infoInit(LOGGER, "JtConfiguration...", new Object[0]);
        JtPin.initializing();
        Jt.infoInit(LOGGER, "Ambient Environment Start...", new Object[0]);
        return Ambient.init(vertx);
    }

    public static JtConfig getConfig() {
        return CONFIG;
    }

    public static UnityApp getUnity() {
        UnityApp unity = (UnityApp)Ut.singleton(CONFIG.getUnity(), (Object[])new Object[0]);
        return Objects.isNull(unity) ? null : unity;
    }
}

