/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.atom;

import cn.vertxup.jet.domain.tables.pojos.IJob;
import cn.vertxup.jet.domain.tables.pojos.IService;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtCommercial;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.eon.em.JobType;
import io.vertx.up.util.Ut;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class JtJob
extends JtCommercial {
    private transient IJob job;
    private transient String key;

    public JtJob() {
    }

    public JtJob(IJob job, IService service) {
        super(service);
        this.job = job;
        this.key = job.getKey();
    }

    public JsonObject options() {
        return Jt.toOptions(this.getApp(), this.job, this.service());
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public JsonObject toJson() {
        JsonObject data = super.toJson();
        data.put("job", (Object)Ut.serializeJson((Object)this.job));
        return data;
    }

    @Override
    public void fromJson(JsonObject data) {
        super.fromJson(data);
        this.key = data.getString("key");
        this.job = (IJob)Ut.deserialize((JsonObject)data.getJsonObject("job"), IJob.class);
    }

    public Mission toJob() {
        Mission mission = new Mission();
        mission.setName(this.job.getName());
        mission.setType((JobType)Ut.toEnum(this.job::getType, JobType.class, (Enum)JobType.ONCE));
        mission.setCode(Jt.jobCode(this.job));
        mission.setReadOnly(Boolean.FALSE.booleanValue());
        mission.setComment(this.job.getComment());
        mission.setAdditional(Ut.toJObject((String)this.job.getAdditional()));
        mission.setMetadata(this.toJson().copy());
        if (Objects.nonNull(this.job.getRunAt())) {
            LocalTime runAt = this.job.getRunAt();
            LocalTime runNow = LocalTime.now();
            LocalDate today = LocalDate.now();
            if (runAt.isBefore(runNow)) {
                today = today.plusDays(1L);
            }
            LocalDateTime result = LocalDateTime.of(today, runAt);
            mission.setInstant(Ut.parse((LocalDateTime)result).toInstant());
        }
        if (Objects.isNull(this.job.getDuration())) {
            mission.setDuration(-1L);
        } else {
            long duration = TimeUnit.SECONDS.toMillis(this.job.getDuration());
            mission.setDuration(duration);
        }
        if (Objects.isNull(this.job.getThreshold())) {
            mission.setThreshold(-1L);
        } else {
            long threshold = TimeUnit.SECONDS.toNanos(this.job.getThreshold().intValue());
            mission.setThreshold(threshold);
        }
        if (Objects.nonNull(this.job.getIncomeComponent())) {
            mission.setIncome(Ut.clazz((String)this.job.getIncomeComponent()));
        }
        mission.setIncomeAddress(this.job.getIncomeAddress());
        if (Objects.nonNull(this.job.getOutcomeComponent())) {
            mission.setOutcome(Ut.clazz((String)this.job.getOutcomeComponent()));
        }
        mission.setOutcomeAddress(this.job.getOutcomeAddress());
        return this.mount(mission);
    }

    private Mission mount(Mission mission) {
        String proxyStr = this.job.getProxy();
        Class clazz = Ut.clazz((String)proxyStr);
        if (Objects.nonNull(clazz)) {
            return mission.connect(clazz);
        }
        return mission;
    }
}

