/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.business;

import cn.vertxup.jet.domain.tables.daos.IApiDao;
import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.tp.optic.business.ExRoute;
import io.vertx.tp.optic.environment.Ambient;
import io.vertx.up.runtime.soul.UriMeta;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExRouteApi
implements ExRoute {
    public Future<List<UriMeta>> searchAsync(String keyword, String sigma) {
        if (Ut.isNil((String)keyword) || Ut.isNil((String)sigma)) {
            return Ux.future(new ArrayList());
        }
        JtApp app = Ambient.getApp(sigma);
        if (Objects.isNull(app)) {
            return Ux.future(new ArrayList());
        }
        JsonObject condition = new JsonObject();
        condition.put("sigma", sigma);
        JsonObject criteria = new JsonObject();
        criteria.put("name,c", keyword);
        criteria.put("comment,c", keyword);
        criteria.put("uri,c", keyword);
        condition.put("$0", criteria);
        return Ux.Jooq.on(IApiDao.class).fetchAndAsync(condition).compose(apis -> {
            ArrayList uris = new ArrayList();
            apis.forEach(api -> {
                UriMeta meta = new UriMeta();
                meta.setDynamic(Boolean.TRUE.booleanValue());
                meta.setKey(api.getKey());
                String uri = Jt.toPath(app::getRoute, api::getUri, api.getSecure());
                meta.setUri(uri);
                meta.setMethod((HttpMethod)Ut.toEnum(api::getMethod, HttpMethod.class, (Enum)HttpMethod.GET));
                meta.setName(api.getName());
                meta.setComment(api.getComment());
                uris.add(meta);
            });
            return Ux.future(uris);
        });
    }
}

