/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.tp.jet.atom.JtConfig;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.ws.rs.core.MediaType;

class JtRoute {
    JtRoute() {
    }

    static Set<String> toSet(Supplier<String> supplier) {
        String inputRequired = supplier.get();
        HashSet<String> result = new HashSet<String>();
        if (Ut.notNil((String)inputRequired) && Ut.isJArray((String)inputRequired)) {
            JsonArray mimeArr = new JsonArray(inputRequired);
            mimeArr.stream().map(item -> (String)item).forEach(result::add);
        }
        return result;
    }

    static String toPath(Supplier<String> routeSupplier, Supplier<String> uriSupplier, boolean secure, JtConfig config) {
        String path;
        String root;
        StringBuilder uri = new StringBuilder();
        if (secure) {
            String wall = config.getWall();
            if (Ut.isNil((String)wall)) {
                wall = "";
            }
            if (wall.startsWith("/")) {
                uri.append(wall);
            } else {
                uri.append(wall);
            }
        }
        if (Ut.notNil((String)(root = routeSupplier.get()))) {
            uri.append(root).append(root.endsWith("/") ? "" : "/");
        }
        if (Ut.notNil((String)(path = uriSupplier.get()))) {
            uri.append(path);
        }
        return uri.toString().replace("//", "/");
    }

    static Set<MediaType> toMime(Supplier<String> supplier) {
        String mime = supplier.get();
        HashSet<MediaType> mimeSet = new HashSet<MediaType>();
        if (Ut.notNil((String)mime) && Ut.isJArray((String)mime)) {
            JsonArray mimeArr = new JsonArray(mime);
            mimeArr.stream().map(item -> (String)item).map(MediaType::valueOf).forEach(mimeSet::add);
        }
        if (mimeSet.isEmpty()) {
            mimeSet.add(MediaType.APPLICATION_JSON_TYPE);
        }
        return mimeSet;
    }
}

