/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.refine;

import cn.vertxup.jet.domain.tables.pojos.IApi;
import cn.vertxup.jet.domain.tables.pojos.IJob;
import cn.vertxup.jet.domain.tables.pojos.IService;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.atom.JtConfig;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.atom.JtWorker;
import io.vertx.tp.jet.refine.JtBusiness;
import io.vertx.tp.jet.refine.JtDataObject;
import io.vertx.tp.jet.refine.JtDelivery;
import io.vertx.tp.jet.refine.JtLog;
import io.vertx.tp.jet.refine.JtRoute;
import io.vertx.tp.jet.refine.JtType;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.config.Identity;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.commune.exchange.DictConfig;
import io.vertx.up.commune.exchange.DualMapping;
import io.vertx.up.commune.rule.RuleUnique;
import io.vertx.up.eon.em.ChannelType;
import io.vertx.up.extension.PlugRouter;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;

public class Jt {
    public static void infoInit(Annal logger, String pattern, Object ... args) {
        JtLog.info(logger, "Init", pattern, args);
    }

    public static void infoRoute(Annal logger, String pattern, Object ... args) {
        JtLog.info(logger, "Route", pattern, args);
    }

    public static void infoWorker(Annal logger, String pattern, Object ... args) {
        JtLog.info(logger, "Worker", pattern, args);
    }

    public static void infoWeb(Annal logger, String pattern, Object ... args) {
        JtLog.info(logger, "Wet", pattern, args);
    }

    public static void warnApp(Annal logger, String pattern, Object ... args) {
        JtLog.warn(logger, "Ambient", pattern, args);
    }

    public static String jobCode(IJob job) {
        return job.getNamespace() + "-" + job.getCode();
    }

    public static String toPath(Supplier<String> routeSupplier, Supplier<String> uriSupplier, boolean secure, JtConfig external) {
        return JtRoute.toPath(routeSupplier, uriSupplier, secure, external);
    }

    public static String toPath(Supplier<String> routeSupplier, Supplier<String> uriSupplier, boolean secure) {
        JsonObject routerConfig = PlugRouter.config();
        JtConfig config = (JtConfig)Ut.deserialize((JsonObject)routerConfig, JtConfig.class);
        return Jt.toPath(routeSupplier, uriSupplier, secure, config);
    }

    public static Set<MediaType> toMime(Supplier<String> supplier) {
        return JtRoute.toMime(supplier);
    }

    public static Set<String> toMimeString(Supplier<String> supplier) {
        return Jt.toMime(supplier).stream().map(type -> type.getType() + "/" + type.getSubtype()).collect(Collectors.toSet());
    }

    public static DictConfig toDict(IService service) {
        return JtBusiness.toDict(service);
    }

    public static DualMapping toMapping(IService service) {
        return JtBusiness.toMapping(service);
    }

    public static Identity toIdentity(IService service) {
        return JtBusiness.toIdentify(service);
    }

    public static Future<ConcurrentMap<String, JsonArray>> toDictionary(String key, String identifier, DictConfig dict) {
        return JtBusiness.toDictionary(key, identifier, dict);
    }

    public static Set<String> toSet(Supplier<String> supplier) {
        return JtRoute.toSet(supplier);
    }

    public static JtWorker toWorker(IApi api) {
        return JtType.toWorker(api);
    }

    public static Class<?> toChannel(Supplier<String> supplier, ChannelType type) {
        return JtType.toChannel(supplier, type);
    }

    public static void initApi(IApi api) {
        JtDataObject.initApi(api);
    }

    public static JsonObject toOptions(JtApp app, IApi api, IService service) {
        return JtDataObject.toOptions(app, api, service);
    }

    public static JsonObject toOptions(JtApp app, IJob job, IService service) {
        return JtDataObject.toOptions(app, job, service);
    }

    public static JsonObject toOptions(JtApp app, IService service) {
        return JtDataObject.toOptions(app, service);
    }

    public static ConcurrentMap<String, JsonObject> ask(Set<JtUri> uriSet) {
        return JtDelivery.ask(uriSet);
    }

    public static ConcurrentMap<String, JtUri> answer(JsonObject config) {
        return JtDelivery.answer(config);
    }

    public static Database toDatabase(Supplier<String> supplier, Database defaultDatabase) {
        return JtDataObject.toDatabase(supplier, defaultDatabase);
    }

    public static Database toDatabase(IService service) {
        return JtDataObject.toDatabase(service);
    }

    public static RuleUnique toRule(IService service) {
        return JtDataObject.toRule(service);
    }

    public static Integration toIntegration(IService service) {
        return JtDataObject.toIntegration(service);
    }
}

