/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.tp.jet.JetCastor;
import io.vertx.tp.jet.Pool;
import io.vertx.tp.jet.atom.JtConfig;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.jet.monitor.JtMonitor;
import io.vertx.tp.jet.uca.aim.EngineAim;
import io.vertx.tp.jet.uca.aim.InAim;
import io.vertx.tp.jet.uca.aim.JtAim;
import io.vertx.tp.jet.uca.aim.PreAim;
import io.vertx.tp.jet.uca.aim.SendAim;
import io.vertx.tp.optic.environment.Ambient;
import io.vertx.tp.optic.environment.AmbientEnvironment;
import io.vertx.up.extension.PlugRouter;
import io.vertx.up.fn.Fn;
import io.vertx.up.runtime.ZeroJet;
import io.vertx.up.uca.web.failure.CommonEndurer;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class JetPollux
implements PlugRouter {
    private static final ConcurrentMap<String, AmbientEnvironment> AMBIENT = Ambient.getEnvironments();
    private static final AtomicBoolean UNREADY = new AtomicBoolean(Boolean.TRUE);
    private final transient JtMonitor monitor = JtMonitor.create(this.getClass());
    private transient JetCastor castor;

    public void mount(Router router, JsonObject config) {
        this.monitor.agentConfig(config);
        if (Objects.isNull(AMBIENT) || AMBIENT.isEmpty()) {
            this.monitor.workerFailure();
        } else {
            Set<JtUri> uriSet = AMBIENT.keySet().stream().flatMap(appId -> ((AmbientEnvironment)AMBIENT.get(appId)).routes().stream()).map(uri -> (JtUri)uri.bind(this.getOrder()).bind((JtConfig)Ut.deserialize((JsonObject)config.copy(), JtConfig.class))).map(uri -> {
                ZeroJet.resolve((HttpMethod)uri.method(), (String)uri.path());
                Route route = router.route();
                this.registryUri(route, (JtUri)uri);
                return uri;
            }).collect(Collectors.toSet());
            this.monitor.workerStart();
            if (Objects.nonNull(this.castor) && UNREADY.getAndSet(Boolean.FALSE)) {
                this.castor.startWorkers(uriSet);
            }
        }
    }

    public void bind(Vertx vertx) {
        if (Objects.nonNull(vertx)) {
            this.castor = JetCastor.create(vertx);
        }
    }

    private void registryUri(Route route, JtUri uri) {
        route.path(uri.path()).order(uri.order().intValue()).method(uri.method());
        uri.consumes().forEach(arg_0 -> ((Route)route).consumes(arg_0));
        uri.produces().forEach(arg_0 -> ((Route)route).produces(arg_0));
        JtAim pre = (JtAim)Fn.poolThread(Pool.AIM_PRE_HUBS, () -> (JtAim)Ut.instance(PreAim.class, (Object[])new Object[0]));
        JtAim in = (JtAim)Fn.poolThread(Pool.AIM_IN_HUBS, () -> (JtAim)Ut.instance(InAim.class, (Object[])new Object[0]));
        JtAim engine = (JtAim)Fn.poolThread(Pool.AIM_ENGINE_HUBS, () -> (JtAim)Ut.instance(EngineAim.class, (Object[])new Object[0]));
        JtAim send = (JtAim)Fn.poolThread(Pool.AIM_SEND_HUBS, () -> (JtAim)Ut.instance(SendAim.class, (Object[])new Object[0]));
        route.handler(pre.attack(uri)).handler(in.attack(uri)).handler(engine.attack(uri)).handler(send.attack(uri)).failureHandler(CommonEndurer.create());
    }
}

