/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.jet.service;

import cn.vertxup.jet.domain.tables.pojos.IService;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.plugin.job.JobPool;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JobKit {
    static Future<JsonArray> fetchMission(Set<String> codes) {
        List missionList = JobPool.get();
        if (Objects.isNull(codes) || codes.isEmpty()) {
            return Ux.future((Object)new JsonArray());
        }
        JsonArray response = new JsonArray();
        missionList.stream().filter(mission -> codes.contains(mission.getCode())).map(JobKit::toJson).forEach(arg_0 -> ((JsonArray)response).add(arg_0));
        return Ux.future((Object)response);
    }

    static Future<JsonObject> fetchMission(String code) {
        List missionList = JobPool.get();
        Mission found = missionList.stream().filter(mission -> code.equals(mission.getCode())).findFirst().orElse(null);
        if (Objects.isNull(found)) {
            return Ux.future((Object)new JsonObject());
        }
        return Ux.future((Object)JobKit.toJson(found));
    }

    public static IService fromJson(JsonObject serviceJson) {
        Ke.mountString((JsonObject)serviceJson, (String)"metadata");
        Ke.mountString((JsonObject)serviceJson, (String)"ruleUnique");
        Ke.mountString((JsonObject)serviceJson, (String)"configIntegration");
        Ke.mountString((JsonObject)serviceJson, (String)"configDatabase");
        Ke.mountString((JsonObject)serviceJson, (String)"channelConfig");
        Ke.mountString((JsonObject)serviceJson, (String)"serviceConfig");
        Ke.mountString((JsonObject)serviceJson, (String)"mappingConfig");
        Ke.mountString((JsonObject)serviceJson, (String)"dictEpsilon");
        Ke.mountString((JsonObject)serviceJson, (String)"dictConfig");
        return (IService)Ux.fromJson((JsonObject)serviceJson, IService.class);
    }

    public static JsonObject toJson(Mission mission) {
        JsonObject service;
        JsonObject serialized = (JsonObject)Ut.serializeJson((Object)mission);
        JsonObject metadata = serialized.getJsonObject("metadata");
        if (Ut.notNil((JsonObject)metadata) && Ut.notNil((JsonObject)(service = metadata.getJsonObject("service")))) {
            Ke.mount((JsonObject)service, (String)"metadata");
            Ke.mount((JsonObject)service, (String)"ruleUnique");
            Ke.mount((JsonObject)service, (String)"configIntegration");
            Ke.mount((JsonObject)service, (String)"configDatabase");
            Ke.mount((JsonObject)service, (String)"channelConfig");
            Ke.mount((JsonObject)service, (String)"serviceConfig");
            Ke.mount((JsonObject)service, (String)"mappingConfig");
            Ke.mount((JsonObject)service, (String)"dictEpsilon");
            Ke.mountArray((JsonObject)service, (String)"dictConfig");
        }
        return serialized;
    }
}

