/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.verticle;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.up.annotations.Agent;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.monitor.MeansureAxis;
import io.vertx.up.uca.options.DynamicVisitor;
import io.vertx.up.uca.options.ServerVisitor;
import io.vertx.up.uca.rs.Axis;
import io.vertx.up.uca.rs.router.PointAxis;
import io.vertx.up.uca.rs.router.RouterAxis;
import io.vertx.up.uca.rs.router.WallAxis;
import io.vertx.up.util.Ut;
import io.vertx.up.verticle.Pool;
import io.vertx.up.verticle.ZeroAtomic;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@Agent(type=ServerType.API)
public class ZeroApiAgent
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroApiAgent.class);
    private static final ServerVisitor<HttpServerOptions> VISITOR = (ServerVisitor)Ut.singleton(DynamicVisitor.class, (Object[])new Object[0]);
    private static final ConcurrentMap<Integer, AtomicInteger> API_START_LOGS = new ConcurrentHashMap<Integer, AtomicInteger>();

    public void start() {
        Axis routerAxiser = (Axis)Fn.poolThread((ConcurrentMap)Pool.ROUTERS, () -> new RouterAxis(this.vertx));
        Axis wallAxiser = (Axis)Fn.poolThread((ConcurrentMap)Pool.WALLS, () -> (Axis)Ut.instance(WallAxis.class, (Object[])new Object[]{this.vertx}));
        Axis montiorAxiser = (Axis)Fn.poolThread((ConcurrentMap)Pool.MEANSURES, () -> new MeansureAxis(this.vertx, true));
        Fn.outUp(() -> ZeroAtomic.API_OPTS.forEach((port, option) -> {
            Axis axiser = (Axis)Fn.poolThread((ConcurrentMap)Pool.APIS, () -> (Axis)Ut.instance(PointAxis.class, (Object[])new Object[]{option, this.vertx}));
            HttpServer server = this.vertx.createHttpServer(option);
            Router router = Router.router((Vertx)this.vertx);
            routerAxiser.mount((Object)router);
            wallAxiser.mount((Object)router);
            montiorAxiser.mount((Object)router);
            axiser.mount((Object)router);
            server.requestHandler((Handler)router).listen();
            this.registryServer((HttpServerOptions)option);
        }), (Annal)LOGGER);
    }

    private void registryServer(HttpServerOptions options) {
        Integer port = options.getPort();
        AtomicInteger out = (AtomicInteger)API_START_LOGS.get(port);
        if (0 == out.getAndIncrement()) {
            String portLiteral = String.valueOf(port);
            LOGGER.info("( Api Gateway ) {0} (id = {1}) has deployed on {2}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.deploymentID(), portLiteral});
            String address = MessageFormat.format("http://{0}:{1}/", options.getHost(), portLiteral);
            LOGGER.info("( Api Gateway ) {0} has been started successfully. Endpoint: {1}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), address});
        }
    }

    static {
        Fn.outUp(() -> {
            if (ZeroAtomic.API_OPTS.isEmpty()) {
                ZeroAtomic.API_OPTS.putAll((Map)VISITOR.visit(new String[]{ServerType.API.toString()}));
                ZeroAtomic.API_OPTS.forEach((port, option) -> API_START_LOGS.put((Integer)port, new AtomicInteger(0)));
            }
        }, (Annal)LOGGER);
    }
}

