/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.options;

import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.Ruler;
import io.vertx.up.exception.ZeroException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.options.Visitor;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;

public class CircuitVisitor
implements Visitor<CircuitBreakerOptions> {
    private static final Annal LOGGER = Annal.get(CircuitVisitor.class);
    private static final String CIRCUIT = "circuit";
    private final transient Node<JsonObject> node = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);

    public CircuitBreakerOptions visit(String ... key) throws ZeroException {
        Fn.inLenEq(this.getClass(), (int)0, (Object[])key);
        JsonObject data = (JsonObject)this.node.read();
        JsonObject config = (JsonObject)Fn.getSemi((data.containsKey(CIRCUIT) && null != data.getValue(CIRCUIT) ? 1 : 0) != 0, (Annal)LOGGER, () -> data.getJsonObject(CIRCUIT), JsonObject::new);
        return this.visit(config);
    }

    private CircuitBreakerOptions visit(JsonObject data) throws ZeroException {
        LOGGER.info("The raw data ( node = {0}, type = {1} ) before validation is {2}.", new Object[]{CIRCUIT, "Circuit", data.encode()});
        Ruler.verify((String)CIRCUIT, (JsonObject)data);
        return new CircuitBreakerOptions(data);
    }
}

