/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.micro.ipc.server;

import io.grpc.BindableService;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.tp.ipc.eon.IpcRequest;
import io.vertx.tp.ipc.eon.IpcResponse;
import io.vertx.tp.ipc.service.VertxUnityServiceGrpc;
import io.vertx.up.annotations.Ipc;
import io.vertx.up.atom.rpc.IpcData;
import io.vertx.up.commune.Envelop;
import io.vertx.up.eon.em.IpcType;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception.web._501RpcMethodMissingException;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.micro.ipc.DataEncap;
import io.vertx.up.uca.micro.ipc.server.Tunnel;
import io.vertx.up.uca.micro.ipc.tower.FinalTransit;
import io.vertx.up.uca.micro.ipc.tower.NodeTransit;
import io.vertx.up.uca.micro.ipc.tower.Transit;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;

public class UnityTunnel
implements Tunnel {
    private static final Annal LOGGER = Annal.get(UnityTunnel.class);

    @Override
    public BindableService init(final Vertx vertx) {
        return new VertxUnityServiceGrpc.UnityServiceVertxImplBase(){

            public void unityCall(IpcRequest request, Future<IpcResponse> future) {
                IpcData data = DataEncap.consume(request, IpcType.UNITY);
                Envelop envelop = DataEncap.consume(data);
                Method method = (Method)Tunnel.IPCS.get(data.getAddress());
                if (null == method) {
                    Envelop community = Envelop.failure((WebException)new _501RpcMethodMissingException(this.getClass(), data.getAddress()));
                    IpcData ipcData = UnityTunnel.this.build(community, envelop);
                } else {
                    Transit transit = UnityTunnel.this.getTransit(method, vertx);
                    Future<Envelop> result = transit.async(envelop);
                    result.onComplete(res -> {
                        if (res.succeeded()) {
                            IpcData ipcData = UnityTunnel.this.build((Envelop)res.result(), envelop);
                        } else {
                            res.cause().printStackTrace();
                        }
                    });
                }
            }
        };
    }

    private IpcData build(Envelop community, Envelop envelop) {
        if (null != envelop) {
            community.from(envelop);
        }
        IpcData responseData = new IpcData();
        responseData.setType(IpcType.UNITY);
        DataEncap.in(responseData, community);
        return responseData;
    }

    private Transit getTransit(Method method, Vertx vertx) {
        Transit transit;
        Ipc annotation = method.getAnnotation(Ipc.class);
        String to = (String)Ut.invoke((Object)annotation, (String)"to", (Object[])new Object[0]);
        if (Ut.isNil((String)to)) {
            transit = (Transit)Ut.singleton(FinalTransit.class, (Object[])new Object[0]);
            LOGGER.info("--> ( Terminator ) found, will provide response. method {0} of {1}", new Object[]{method, method.getDeclaringClass()});
        } else {
            transit = (Transit)Ut.singleton(NodeTransit.class, (Object[])new Object[0]);
            LOGGER.info("--> ( Coordinator ) found, will transfer -->. method {0} of {1}", new Object[]{method, method.getDeclaringClass()});
        }
        return transit.connect(vertx).connect(method);
    }
}

