/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ipc.service;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.grpc.stub.ClientCalls;
import io.vertx.tp.ipc.eon.IpcRequest;
import io.vertx.tp.ipc.eon.IpcResponse;
import io.vertx.tp.ipc.service.UnityServiceGrpc;

public final class VertxUnityServiceGrpc {
    private static final int METHODID_UNITY_CALL = 0;

    private VertxUnityServiceGrpc() {
    }

    public static UnityServiceVertxStub newVertxStub(Channel channel) {
        return new UnityServiceVertxStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final UnityServiceVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(UnityServiceVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((IpcRequest)request), responseObserver, (String)this.compression, this.serviceImpl::unityCall);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class UnityServiceVertxImplBase
    implements BindableService {
        private String compression;

        public UnityServiceVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<IpcResponse> unityCall(IpcRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)UnityServiceGrpc.getServiceDescriptor()).addMethod(UnityServiceGrpc.METHOD_UNITY_CALL, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).build();
        }
    }

    public static final class UnityServiceVertxStub
    extends AbstractStub<UnityServiceVertxStub> {
        private final ContextInternal ctx;
        private UnityServiceGrpc.UnityServiceStub delegateStub;

        private UnityServiceVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = UnityServiceGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private UnityServiceVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = UnityServiceGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        protected UnityServiceVertxStub build(Channel channel, CallOptions callOptions) {
            return new UnityServiceVertxStub(channel, callOptions);
        }

        public Future<IpcResponse> unityCall(IpcRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::unityCall);
        }
    }
}

