/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ipc.service;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.stub.ClientCalls;
import io.vertx.tp.ipc.eon.StreamClientRequest;
import io.vertx.tp.ipc.eon.StreamClientResponse;
import io.vertx.tp.ipc.service.ProduceServiceGrpc;

public final class VertxProduceServiceGrpc {
    private static final int METHODID_INPUT_CALL = 0;

    private VertxProduceServiceGrpc() {
    }

    public static ProduceServiceVertxStub newVertxStub(Channel channel) {
        return new ProduceServiceVertxStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ProduceServiceVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(ProduceServiceVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return io.vertx.grpc.stub.ServerCalls.manyToMany(responseObserver, (String)this.compression, this.serviceImpl::inputCall);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class ProduceServiceVertxImplBase
    implements BindableService {
        private String compression;

        public ProduceServiceVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public void inputCall(ReadStream<StreamClientRequest> request, WriteStream<StreamClientResponse> response) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)ProduceServiceGrpc.getServiceDescriptor()).addMethod(ProduceServiceGrpc.METHOD_INPUT_CALL, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0, this.compression))).build();
        }
    }

    public static final class ProduceServiceVertxStub
    extends AbstractStub<ProduceServiceVertxStub> {
        private final ContextInternal ctx;
        private ProduceServiceGrpc.ProduceServiceStub delegateStub;

        private ProduceServiceVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = ProduceServiceGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private ProduceServiceVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = ProduceServiceGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        protected ProduceServiceVertxStub build(Channel channel, CallOptions callOptions) {
            return new ProduceServiceVertxStub(channel, callOptions);
        }

        public ReadStream<StreamClientResponse> inputCall(Handler<WriteStream<StreamClientRequest>> hdlr) {
            return ClientCalls.manyToMany((ContextInternal)this.ctx, hdlr, this.delegateStub::inputCall);
        }
    }
}

