/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ipc.service;

import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.stub.ClientCalls;
import io.vertx.tp.ipc.eon.StreamServerRequest;
import io.vertx.tp.ipc.eon.StreamServerResponse;
import io.vertx.tp.ipc.service.ConsumeServiceGrpc;

public final class VertxConsumeServiceGrpc {
    private static final int METHODID_OUTPUT_CALL = 0;

    private VertxConsumeServiceGrpc() {
    }

    public static ConsumeServiceVertxStub newVertxStub(Channel channel) {
        return new ConsumeServiceVertxStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ConsumeServiceVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(ConsumeServiceVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return io.vertx.grpc.stub.ServerCalls.manyToMany(responseObserver, (String)this.compression, this.serviceImpl::outputCall);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class ConsumeServiceVertxImplBase
    implements BindableService {
        private String compression;

        public ConsumeServiceVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public void outputCall(ReadStream<StreamServerRequest> request, WriteStream<StreamServerResponse> response) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)ConsumeServiceGrpc.getServiceDescriptor()).addMethod(ConsumeServiceGrpc.METHOD_OUTPUT_CALL, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0, this.compression))).build();
        }
    }

    public static final class ConsumeServiceVertxStub
    extends AbstractStub<ConsumeServiceVertxStub> {
        private final ContextInternal ctx;
        private ConsumeServiceGrpc.ConsumeServiceStub delegateStub;

        private ConsumeServiceVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = ConsumeServiceGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private ConsumeServiceVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = ConsumeServiceGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        protected ConsumeServiceVertxStub build(Channel channel, CallOptions callOptions) {
            return new ConsumeServiceVertxStub(channel, callOptions);
        }

        public ReadStream<StreamServerResponse> outputCall(Handler<WriteStream<StreamServerRequest>> hdlr) {
            return ClientCalls.manyToMany((ContextInternal)this.ctx, hdlr, this.delegateStub::outputCall);
        }
    }
}

