/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.micro.ssl;

import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.up.eon.em.CertType;
import io.vertx.up.uca.micro.ssl.client.JksTrust;
import io.vertx.up.uca.micro.ssl.client.PemTrust;
import io.vertx.up.uca.micro.ssl.client.PfxTrust;
import io.vertx.up.util.Ut;

public interface TrustPipe<I> {
    public static TrustPipe<JsonObject> get(CertType type) {
        TrustPipe pipe = null;
        switch (type) {
            case PKCS12: {
                pipe = (TrustPipe)Ut.singleton(PfxTrust.class, (Object[])new Object[0]);
                break;
            }
            case JKS: {
                pipe = (TrustPipe)Ut.singleton(JksTrust.class, (Object[])new Object[0]);
                break;
            }
            case PEM: {
                pipe = (TrustPipe)Ut.singleton(PemTrust.class, (Object[])new Object[0]);
            }
        }
        return pipe;
    }

    public Handler<ClientOptionsBase> parse(I var1);
}

